/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounter
extends GuiParent {
    public int min;
    public int max;
    public GuiTextfield textfield;

    public GuiCounter(String name, int value, int min, int max) {
        super(name);
        this.min = min;
        this.max = max;
        this.flow = GuiFlow.STACK_X;
        this.valign = VAlign.STRETCH;
        this.spacing = 0;
        this.textfield = new GuiTextfield("value", "" + Mth.m_14045_((int)value, (int)min, (int)max)).setDim(20, 8).setNumbersOnly();
        this.add(this.textfield.setExpandableX());
        GuiParent buttons = new GuiParent(GuiFlow.STACK_Y);
        this.add(buttons);
        buttons.add(new GuiButtonHoldSlim("+", x -> {
            this.textfield.setText("" + this.stepUp(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent(this));
        }).setTranslate("gui.plus"));
        buttons.add(new GuiButtonHoldSlim("-", x -> {
            this.textfield.setText("" + this.stepDown(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent(this));
        }).setTranslate("gui.minus"));
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    public int stepUp(int value) {
        return Math.min(this.max, value + 1);
    }

    public int stepDown(int value) {
        return Math.max(this.min, value - 1);
    }

    public int getValue() {
        return Mth.m_14045_((int)this.textfield.parseInteger(), (int)this.min, (int)this.max);
    }

    public void setValue(int value) {
        this.textfield.setText("" + Mth.m_14045_((int)value, (int)this.min, (int)this.max));
    }
}

