/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.timeline;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiTimeline
extends GuiParent {
    protected static final double MAXIMUM_RELATIVE_ZOOM = 2.0;
    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay cursorHighlight;
    private final GuiRow header;
    private final List<GuiTimelineChannel> channels = new ArrayList<GuiTimelineChannel>();
    private final GuiParent sidebar;
    private final GuiParent channelbar;
    private int tick;
    protected int duration = 100;
    protected double ticksPerPixel;
    protected double basePixelWidth;
    protected int headerHeight = 12;
    protected int channelHeight = 10;
    protected int sidebarWidth = 50;
    protected int timelineOffset = 2;
    protected SmoothValue zoom = new SmoothValue(100L);
    protected SmoothValue scrollX = new SmoothValue(100L);
    private GuiTimelineKey selected;
    private double lastZoom = 0.0;
    protected double sizeX;
    protected double maxScrollX;
    protected double maximumZoom;

    public GuiTimeline() {
        this.align = Align.STRETCH;
        this.valign = VAlign.STRETCH;
        this.flow = GuiFlow.STACK_Y;
        this.spacing = -1;
        this.header = new GuiRow((GuiColumn.GuiColumnHeader)new GuiColumn.GuiColumnHeader().setDim(new GuiSizeRule.GuiFixedDimension(this.sidebarWidth)), new GuiTimelineHeader());
        this.header.setDim(new GuiSizeRule.GuiSizeRules().prefHeight(14));
        this.header.spacing = -1;
        this.add(this.header);
        GuiScrollY channelParent = new GuiScrollY(){

            @Override
            public ControlFormatting getControlFormatting() {
                return ControlFormatting.TRANSPARENT;
            }
        }.setHovered();
        channelParent.spacing = -1;
        channelParent.align = Align.STRETCH;
        channelParent.flow = GuiFlow.STACK_X;
        this.add(channelParent);
        this.sidebar = new GuiParent(GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        channelParent.add(this.sidebar);
        this.channelbar = new GuiParent(GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        channelParent.add(this.channelbar.setExpandableX());
    }

    public GuiTimeline setDuration(int duration) {
        this.duration = duration;
        this.adjustKeysPositionX();
        this.scrollX.setStart(0.0);
        this.zoom.setStart(0.0);
        return this;
    }

    public void selectKey(GuiTimelineKey key) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = key;
        this.selected.setSelected(true);
        this.raiseEvent(new KeySelectedEvent(key));
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        boolean result = super.mouseClicked(rect, x, y, button);
        if (!result && button == 0) {
            if (this.selected != null) {
                this.selected.setSelected(false);
                this.selected = null;
                this.raiseEvent(new NoKeySelectedEvent(this));
            }
            return false;
        }
        return result;
    }

    public double scrolledX() {
        return this.scrollX.current();
    }

    public void adjustKeyPositionX(GuiTimelineKey key) {
        GuiChildControl child = key.channel.find(key);
        child.setX(this.timelineOffset - 2 + (int)((double)((GuiTimelineKey)child.control).tick * this.getTickWidth()) - child.getWidth() / 2);
    }

    public void adjustKeysPositionX() {
        double tickWidth = this.getTickWidth();
        for (GuiTimelineChannel channel : this.channels) {
            for (GuiChildControl key : channel) {
                key.setX(this.timelineOffset - 2 + (int)((double)((GuiTimelineKey)key.control).tick * tickWidth) - key.getWidth() / 2);
            }
        }
    }

    public void setSidebarWidth(int sidebarWidth) {
        this.sidebarWidth = sidebarWidth;
        this.sidebar.setDim(sidebarWidth, -1);
    }

    public GuiTimelineChannel addGuiTimelineChannel(MutableComponent title) {
        GuiColumn.GuiColumnHeader left = new GuiColumn.GuiColumnHeader();
        left.add(new GuiLabel("title").setDropShadow(false).setDefaultColor(-16777216).setTitle((Component)title.m_130940_(ChatFormatting.BOLD)));
        this.sidebar.add(left.setVAlign(VAlign.CENTER).setDim(this.sidebarWidth, this.channelHeight));
        GuiTimelineChannel channel = new GuiTimelineChannel(this, title);
        this.channels.add(channel);
        this.channelbar.add(channel.setDim(-1, this.channelHeight));
        return channel;
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    protected double getTickWidth() {
        return this.basePixelWidth + this.zoom.current();
    }

    protected double getTickWidthAimed() {
        return this.basePixelWidth + this.zoom.aimed();
    }

    public int getTimeAt(double x) {
        double tickWidth = this.getTickWidth();
        return Mth.m_14045_((int)((int)((x - (double)this.timelineOffset + tickWidth / 2.0 + this.scrollX.current()) / tickWidth)), (int)0, (int)this.duration);
    }

    public int getTimeAtAimed(double x) {
        double tickWidth = this.getTickWidthAimed();
        return Mth.m_14045_((int)((int)((x - (double)this.timelineOffset + tickWidth / 2.0 + this.scrollX.current()) / tickWidth)), (int)0, (int)this.duration);
    }

    public int getTime() {
        return this.tick;
    }

    public void setTime(int tick) {
        this.tick = tick;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        this.ticksPerPixel = (double)this.duration / (double)width;
        this.basePixelWidth = 1.0 / this.ticksPerPixel;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        this.zoom.tick();
        this.scrollX.tick();
        int usuableWidth = (int)rect.getWidth() - this.sidebarWidth;
        double tickWidth = this.getTickWidth();
        if (this.lastZoom != this.zoom.current()) {
            this.sizeX = (double)this.timelineOffset + tickWidth * (double)this.duration;
            this.maxScrollX = Math.max(0.0, this.sizeX - (double)usuableWidth);
            this.lastZoom = this.zoom.current();
            this.adjustKeysPositionX();
        }
        super.renderContent(pose, control, rect, mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        if (Screen.m_96638_()) {
            this.scrollX.set(Mth.m_14008_((double)(this.scrollX.aimed() - delta * 10.0), (double)0.0, (double)this.maxScrollX));
            return true;
        }
        int focusedTick = Math.max(0, this.getTimeAtAimed(x));
        int currentTick = Math.max(0, this.getTimeAtAimed(x));
        double aimedTickWidth = this.getTickWidthAimed();
        double sizeX = aimedTickWidth * (double)this.duration;
        double maxScrollX = Math.max(0.0, sizeX - (rect.getWidth() - (double)(this.getContentOffset() * 2)));
        this.scrollX.set(Mth.m_14008_((double)(this.scrollX.aimed() + (double)(focusedTick - currentTick) * aimedTickWidth), (double)0.0, (double)maxScrollX));
        return true;
    }

    public class GuiTimelineHeader
    extends GuiColumn.GuiColumnHeader {
        public boolean dragged = false;

        public GuiTimelineHeader() {
            this.setExpandableX();
        }

        @Override
        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            this.dragged = true;
            GuiTimeline.this.setTime(GuiTimeline.this.getTimeAt(x));
            GuiTimelineHeader.playSound(SoundEvents.f_144158_);
            return true;
        }

        @Override
        public void mouseMoved(Rect rect, double x, double y) {
            int tick;
            if (this.dragged && (tick = GuiTimeline.this.getTimeAt(x)) != GuiTimeline.this.getTime()) {
                GuiTimeline.this.setTime(tick);
                GuiTimelineHeader.playSound(SoundEvents.f_144158_, 0.02f, 1.0f);
            }
        }

        @Override
        public void mouseReleased(Rect rect, double x, double y, int button) {
            this.dragged = false;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
            if (GuiTimeline.this.cursorHighlight == null) {
                GuiTimeline.this.cursorHighlight = new DisplayColor(0.78f, 0.78f, 0.0f, 0.59f);
            }
            int usuableWidth = (int)rect.getWidth();
            int height = control.getHeight();
            int contentOffset = this.getContentOffset() - 1;
            pose.m_252880_((float)(GuiTimeline.this.timelineOffset - 1), (float)(-contentOffset), 0.0f);
            double tickWidth = GuiTimeline.this.getTickWidth();
            int ticks = (int)((double)usuableWidth / tickWidth);
            int area = 5;
            int halfArea = 5;
            int smallestStep = 0;
            while (Math.pow(area, smallestStep) * tickWidth < 3.0) {
                ++smallestStep;
            }
            smallestStep = (int)Math.pow(area, smallestStep);
            double stepWidth = tickWidth * (double)smallestStep;
            int stepOffset = (int)(GuiTimeline.this.scrollX.current() / stepWidth);
            int stamps = ticks / smallestStep;
            int begin = Math.max(0, stepOffset);
            int end = stepOffset + stamps + 1;
            int pointerWidth = Math.max((int)tickWidth, 1);
            GuiTimeline.this.cursorHighlight.render(pose, tickWidth * (double)GuiTimeline.this.getTime() - (double)pointerWidth / 2.0 - GuiTimeline.this.scrollX.current(), 0.0, pointerWidth, height);
            GuiStyle style = this.getStyle();
            StyleDisplay border = style.get(ControlFormatting.ControlStyleBorder.SMALL);
            Font font = GuiRenderHelper.getFont();
            pose.m_85836_();
            pose.m_85837_(-GuiTimeline.this.scrollX.current() + (double)begin * stepWidth, 0.0, 0.0);
            for (int i = begin; i < end; ++i) {
                if (i % halfArea == 0) {
                    border.render(pose, 1.0, 4.0);
                    String text = "" + i * smallestStep;
                    font.m_92883_(pose, text, (float)(0 - font.m_92895_(text) / 2), 5.0f, -16777216);
                } else {
                    border.render(pose, 1.0, 2.0);
                }
                pose.m_85837_(stepWidth, 0.0, 0.0);
            }
            pose.m_85849_();
        }
    }

    public static class KeySelectedEvent
    extends GuiControlEvent {
        public KeySelectedEvent(GuiTimelineKey source) {
            super(source);
        }

        @Override
        public boolean cancelable() {
            return false;
        }
    }

    public static class NoKeySelectedEvent
    extends GuiControlEvent {
        public NoKeySelectedEvent(GuiTimeline timeline) {
            super(timeline);
        }

        @Override
        public boolean cancelable() {
            return false;
        }
    }
}

