/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.list.PairList;

public class GuiTimelineChannel
extends GuiParent {
    public final GuiTimeline timeline;
    private int cachedHeight;
    public List<GuiTimelineKey> keys = new ArrayList<GuiTimelineKey>();
    private GuiTimelineKey dragged;

    public GuiTimelineChannel(GuiTimeline timeline, MutableComponent title) {
        this.timeline = timeline;
        this.valign = VAlign.CENTER;
    }

    public GuiTimelineChannel addKeyFixed(int tick, double value) {
        GuiTimelineKey key = this.addKey(tick, value);
        key.modifiable = false;
        return this;
    }

    public GuiTimelineKey addKey(int tick, double value) {
        GuiTimelineKey key = new GuiTimelineKey(this, tick, value);
        GuiChildControl child = this.add(key);
        child.setWidth(child.getPreferredWidth(0), 0);
        child.flowX();
        child.setHeight(child.getPreferredHeight(0), 0);
        child.flowY();
        child.setY(this.cachedHeight / 2 - child.getHeight() / 2);
        this.timeline.adjustKeyPositionX(key);
        for (int i = 0; i < this.keys.size(); ++i) {
            GuiTimelineKey other = this.keys.get(i);
            if (other.tick == tick) {
                return null;
            }
            if (other.tick <= tick) continue;
            this.keys.add(i, key);
            return key;
        }
        this.keys.add(key);
        return key;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        this.cachedHeight = height;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    public double getOffsetX() {
        return -this.timeline.scrolledX();
    }

    public void select(GuiTimelineKey key) {
        this.timeline.selectKey(key);
    }

    public void removeKey(GuiTimelineKey key) {
        this.keys.remove(key);
        this.remove(key);
    }

    public void movedKey(GuiTimelineKey key) {
        Collections.sort(this.keys);
    }

    public void dragKey(GuiTimelineKey key) {
        if (key.modifiable) {
            this.dragged = key;
        }
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        int tick;
        if (this.dragged != null && this.dragged.channel.isSpaceFor(this.dragged, tick = Math.max(0, this.timeline.getTimeAt(x)))) {
            this.dragged.tick = tick;
            this.timeline.adjustKeyPositionX(this.dragged);
        }
        super.mouseMoved(rect, x, y);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        if (this.dragged != null) {
            this.dragged.channel.movedKey(this.dragged);
            this.dragged = null;
        }
        super.mouseReleased(rect, x, y, button);
    }

    public boolean isSpaceFor(GuiTimelineKey key, int tick) {
        for (int i = 0; i < this.keys.size(); ++i) {
            int otherTick = this.keys.get((int)i).tick;
            if (otherTick == tick) {
                return false;
            }
            if (otherTick <= tick) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        boolean result = super.mouseClicked(rect, x, y, button);
        if (!result && button == 1) {
            this.addKey(this.timeline.getTimeAt(x), 0.0);
            return true;
        }
        return result;
    }

    public PairList<Integer, Double> getPairs() {
        if (this.controls.isEmpty()) {
            return null;
        }
        boolean fixed = true;
        PairList<Integer, Double> list = new PairList<Integer, Double>();
        for (GuiTimelineKey control : this.keys) {
            if (control.modifiable) {
                fixed = false;
            }
            list.add((Integer)control.tick, control.value);
        }
        if (fixed) {
            return null;
        }
        return list;
    }
}

