/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackY
extends GuiFlow {
    @Override
    public int minWidth(List<GuiChildControl> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiChildControl child : controls) {
            width = Math.max(width, child.getMinWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int preferredWidth(List<GuiChildControl> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiChildControl child : controls) {
            width = Math.max(width, child.getPreferredWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int minHeight(List<GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        boolean has = false;
        for (GuiChildControl child : controls) {
            int min = child.getMinHeight(availableHeight);
            if (min != -1) {
                height += min;
                has = true;
            }
            height += spacing;
        }
        return has ? height : -1;
    }

    @Override
    public int preferredHeight(List<GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        for (GuiChildControl child : controls) {
            height += child.getPreferredHeight(availableHeight) + spacing;
        }
        return height;
    }

    @Override
    public void flowX(List<GuiChildControl> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        int maxWidth = width;
        if (endless && preferred < width) {
            maxWidth = preferred;
        }
        boolean expandable = GuiStackY.areChildrenExpandableX(controls);
        if (align == Align.LEFT && !expandable) {
            for (GuiChildControl child : controls) {
                child.setX(0);
                child.setWidth(Math.min(maxWidth, child.getPreferredWidth(width)), width);
                child.flowX();
            }
        } else if (align == Align.STRETCH || expandable) {
            for (GuiChildControl child : controls) {
                if (child.isExpandableX() || align == Align.STRETCH) {
                    child.setWidth(maxWidth, width);
                } else {
                    child.setWidth(Math.min(maxWidth, child.getPreferredWidth(width)), width);
                }
                child.setX(0);
                child.flowX();
            }
        } else if (align == Align.RIGHT) {
            for (GuiChildControl child : controls) {
                child.setWidth(Math.min(maxWidth, child.getPreferredWidth(width)), width);
                child.setX(maxWidth - child.getWidth());
                child.flowX();
            }
        } else {
            for (GuiChildControl child : controls) {
                child.setWidth(Math.min(maxWidth, child.getPreferredWidth(width)), width);
                child.setX((int)Math.ceil((double)maxWidth / 2.0 - (double)child.getWidth() / 2.0));
                child.flowX();
            }
        }
    }

    @Override
    public void flowY(List<GuiChildControl> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = height - spacing * (controls.size() - 1);
                    MarkList<GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (height >= preferred) {
                        if (valign == VAlign.STRETCH && !GuiStackY.areChildrenExpandableY(controls)) {
                            for (GuiChildControl child : list) {
                                int min = child.getMinHeight(height);
                                if (min != -1) {
                                    available -= min;
                                    child.setHeight(min, height);
                                    continue;
                                }
                                child.setHeight(0, height);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                itr = list.iterator();
                                while (itr.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)itr.next();
                                    int toAdd = Maths.min(average, available, child.getPreferredHeight(height) - child.getHeight());
                                    if (toAdd <= 0) {
                                        itr.mark();
                                        continue;
                                    }
                                    available -= child.addHeight(toAdd, height);
                                    if (!child.isMaxHeight(height)) continue;
                                    itr.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                itr = list.iterator();
                                while (itr.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)itr.next();
                                    available -= child.addHeight(Math.min(average, available), height);
                                    if (!child.isMaxHeight(height)) continue;
                                    itr.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child;
                                child = (GuiChildControl)itr.next();
                                child.setHeight(child.getPreferredHeight(height), height);
                                if (!child.isExpandableY()) {
                                    itr.mark();
                                }
                                available -= child.getHeight();
                            }
                            if (valign == VAlign.STRETCH || GuiStackY.areChildrenExpandableY(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    itr = list.iterator();
                                    while (itr.hasNext()) {
                                        GuiChildControl child = (GuiChildControl)itr.next();
                                        available -= child.addHeight(Math.min(average, available), height);
                                        if (!child.isMaxHeight(height)) continue;
                                        itr.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiChildControl child : controls) {
                            child.setHeight(child.getPreferredHeight(height), height);
                        }
                        valign = VAlign.TOP;
                    } else {
                        for (GuiChildControl child : list) {
                            int min = child.getMinHeight(height);
                            if (min != -1) {
                                available -= min;
                                child.setHeight(min, height);
                                continue;
                            }
                            child.setHeight(0, height);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child = (GuiChildControl)itr.next();
                                int prefer = child.getPreferredHeight(height);
                                available -= child.addHeight(Math.min(average, Math.min(prefer - child.getHeight(), available)), height);
                                if (!child.isMaxHeight(height) && prefer > child.getHeight()) continue;
                                itr.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child = (GuiChildControl)itr.next();
                                available -= child.addHeight(Math.min(average, available), height);
                                if (!child.isMaxHeight(height)) continue;
                                itr.mark();
                            }
                        }
                    }
                    for (GuiChildControl child : controls) {
                        child.flowY();
                    }
                    if (available > 0 && valign != VAlign.TOP) break block29;
                    int y = 0;
                    for (GuiChildControl child : controls) {
                        child.setY(y);
                        y += child.getHeight() + spacing;
                    }
                    break block30;
                }
                if (valign != VAlign.BOTTOM) break block31;
                int y = height;
                for (GuiChildControl child : controls) {
                    child.setY(y -= child.getHeight());
                    y -= spacing;
                }
                break block30;
            }
            if (valign != VAlign.CENTER && valign != VAlign.STRETCH) break block30;
            int y = available / 2;
            for (GuiChildControl child : controls) {
                child.setY(y);
                y += child.getHeight() + spacing;
            }
        }
    }
}

