/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public interface IGuiIntegratedParent
extends IGuiParent {
    public static final GuiLayer EMPTY = new GuiLayer("empty"){

        @Override
        public void create() {
        }
    };

    public List<GuiLayer> getLayers();

    public GuiLayer getTopLayer();

    default public boolean isOpen(Class<? extends GuiLayer> clazz) {
        for (GuiLayer layer : this.getLayers()) {
            if (!clazz.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void render(PoseStack matrixStack, Screen screen, ScreenEventListener listener, int mouseX, int mouseY) {
        int width = screen.f_96543_;
        int height = screen.f_96544_;
        listener.tick();
        Rect screenRect = Rect.getScreenRect();
        List<GuiLayer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            GuiLayer layer = layers.get(i);
            if (i == layers.size() - 1) {
                RenderSystem.m_69465_();
                if (layer.hasGrayBackground()) {
                    GuiRenderHelper.verticalGradientRect(matrixStack, 0, 0, width, height, -1072689136, -804253680);
                }
                if (screen instanceof AbstractContainerScreen) {
                    MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)screen, matrixStack, mouseX, mouseY));
                }
            }
            matrixStack.m_85836_();
            int offX = (width - layer.getWidth()) / 2;
            int offY = (height - layer.getHeight()) / 2;
            matrixStack.m_252880_((float)offX, (float)offY, 0.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Rect controlRect = new Rect(offX, offY, offX + layer.getWidth(), offY + layer.getHeight());
            layer.render(matrixStack, null, controlRect, screenRect.intersection(controlRect), 1.0, mouseX, mouseY);
            matrixStack.m_85849_();
            RenderSystem.m_69471_();
        }
        if (layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.getTopLayer();
        GuiTooltipEvent event = layer.getTooltipEvent(null, mouseX - listener.getOffsetX(), mouseY - listener.getOffsetY());
        if (event != null) {
            layer.raiseEvent(event);
            if (!event.isCanceled()) {
                screen.renderTooltip(matrixStack, event.tooltip, Optional.empty(), mouseX, mouseY, Minecraft.m_91087_().f_91062_);
            }
        }
    }

    @Override
    default public void raiseEvent(GuiEvent event) {
    }

    @Override
    default public void reflow() {
    }

    public void openLayer(GuiLayer var1);

    public void closeLayer(int var1);

    @Override
    default public boolean isParent(IGuiParent parent) {
        return parent == this;
    }

    @Override
    default public boolean hasGui() {
        return true;
    }

    default public GuiControl get(String control) {
        for (GuiLayer layer : this.getLayers()) {
            if (!control.startsWith(layer.getNestedName())) continue;
            if (control.equals(layer.getNestedName())) {
                return layer;
            }
            return layer.get(control.substring(layer.getNestedName().length() + 1));
        }
        return null;
    }

    @Override
    default public Rect toScreenRect(GuiControl control, Rect rect) {
        if (control instanceof GuiLayer) {
            GuiLayer layer = (GuiLayer)control;
            int offX = (Minecraft.m_91087_().m_91268_().m_85445_() - layer.getWidth()) / 2;
            int offY = (Minecraft.m_91087_().m_91268_().m_85446_() - layer.getHeight()) / 2;
            rect.move(offX, offY);
        }
        return rect;
    }

    @Override
    default public Rect toLayerRect(GuiControl control, Rect rect) {
        return rect;
    }

    @Override
    default public IGuiIntegratedParent getIntegratedParent() {
        return this;
    }

    public void send(CreativePacket var1);
}

