/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.NormalPlane;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Facing {
    DOWN(Axis.Y, false, new Vec3i(0, -1, 0), -1){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public Direction toVanilla() {
            return Direction.DOWN;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82289_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252392_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165887_(value);
        }
    }
    ,
    UP(Axis.Y, true, new Vec3i(0, 1, 0), -1){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public Direction toVanilla() {
            return Direction.UP;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82292_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252436_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165893_(value);
        }
    }
    ,
    NORTH(Axis.Z, false, new Vec3i(0, 0, -1), 2){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.NORTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82290_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252393_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165889_(value);
        }
    }
    ,
    SOUTH(Axis.Z, true, new Vec3i(0, 0, 1), 0){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.SOUTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82293_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252403_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165895_(value);
        }
    }
    ,
    WEST(Axis.X, false, new Vec3i(-1, 0, 0), 1){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.WEST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82288_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252495_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165880_(value);
        }
    }
    ,
    EAST(Axis.X, true, new Vec3i(1, 0, 0), 3){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.EAST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82291_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252529_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165891_(value);
        }
    };

    public static final Facing[] VALUES;
    public static final Facing[] HORIZONTA_VALUES;
    public static final String[] FACING_NAMES;
    public static final String[] HORIZONTAL_FACING_NAMES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final Vec3i normal;
    public final NormalPlane plane;
    public final int horizontalIndex;

    public static Facing get(int index) {
        return VALUES[index];
    }

    public static Facing get(Direction direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public static Facing get(Axis axis, boolean positive) {
        return switch (axis) {
            case Axis.X -> {
                if (positive) {
                    yield EAST;
                }
                yield WEST;
            }
            case Axis.Y -> {
                if (positive) {
                    yield UP;
                }
                yield DOWN;
            }
            case Axis.Z -> {
                if (positive) {
                    yield SOUTH;
                }
                yield NORTH;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    public static Facing getHorizontal(int index) {
        return HORIZONTA_VALUES[index];
    }

    public static Facing direction(Vec3i pos, Vec3i second) {
        if (pos.m_123341_() == second.m_123341_()) {
            if (pos.m_123342_() == second.m_123342_()) {
                if (pos.m_123343_() == second.m_123343_() + 1) {
                    return SOUTH;
                }
                return NORTH;
            }
            if (pos.m_123342_() == second.m_123342_() + 1) {
                return UP;
            }
            return DOWN;
        }
        if (pos.m_123341_() == second.m_123341_() + 1) {
            return EAST;
        }
        return WEST;
    }

    private Facing(Axis axis, boolean positive, Vec3i normal, int horizontalIndex) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.plane = new NormalPlane(this);
        this.horizontalIndex = horizontalIndex;
    }

    public int offset() {
        return this.positive ? 1 : -1;
    }

    public int offset(Axis axis) {
        if (this.axis == axis) {
            return this.offset();
        }
        return 0;
    }

    public Component translate() {
        return Component.m_237115_((String)("facing." + this.name));
    }

    public abstract Facing opposite();

    public abstract Direction toVanilla();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public Axis getUAxis() {
        return switch (this.axis) {
            case Axis.X -> Axis.Z;
            case Axis.Y -> Axis.X;
            case Axis.Z -> Axis.X;
            default -> null;
        };
    }

    public Axis getVAxis() {
        return switch (this.axis) {
            case Axis.X -> Axis.Y;
            case Axis.Y -> Axis.Z;
            case Axis.Z -> Axis.Y;
            default -> null;
        };
    }

    public float getU(float x, float y, float z) {
        return switch (this.axis) {
            case Axis.X -> z;
            case Axis.Y -> x;
            case Axis.Z -> x;
            default -> 0.0f;
        };
    }

    public float getV(float x, float y, float z) {
        return switch (this.axis) {
            case Axis.X -> y;
            case Axis.Y -> z;
            case Axis.Z -> y;
            default -> 0.0f;
        };
    }

    public abstract double get(AABB var1);

    public abstract AABB set(AABB var1, double var2);

    public abstract com.mojang.math.Axis rotation();

    static {
        VALUES = new Facing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTA_VALUES = new Facing[]{SOUTH, WEST, NORTH, EAST};
        FACING_NAMES = new String[]{"down", "up", "north", "south", "west", "east"};
        HORIZONTAL_FACING_NAMES = new String[]{"north", "south", "west", "east"};
    }
}

