/*
 * Decompiled with CFR 0.152.
 */
package artifacts.capability;

import artifacts.Artifacts;
import artifacts.capability.SwimHandlerProvider;
import artifacts.network.NetworkHandler;
import artifacts.network.SinkPacket;
import artifacts.network.SwimPacket;
import artifacts.registry.ModGameRules;
import be.florens.expandability.api.forge.PlayerSwimEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class SwimHandler
implements INBTSerializable<CompoundTag> {
    public static final Capability<SwimHandler> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SwimHandler>(){});
    private boolean shouldSwim;
    private boolean shouldSink;
    private boolean hasTouchedWater;
    private int swimTime;

    public boolean isSwimming() {
        return this.shouldSwim;
    }

    public boolean isSinking() {
        return this.shouldSink;
    }

    public boolean isWet() {
        return this.hasTouchedWater;
    }

    public int getSwimTime() {
        return this.swimTime;
    }

    public void setSwimming(boolean shouldSwim) {
        if (this.shouldSwim && !shouldSwim) {
            int rechargeTime = Math.max(1, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get() * 20);
            int maxFlightTime = Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() * 20);
            this.setSwimTime((int)((float)(-rechargeTime * this.getSwimTime()) / (float)maxFlightTime));
        }
        this.shouldSwim = shouldSwim;
    }

    public void setSinking(boolean shouldSink) {
        this.shouldSink = shouldSink;
    }

    public void setWet(boolean hasTouchedWater) {
        this.hasTouchedWater = hasTouchedWater;
    }

    public void setSwimTime(int swimTime) {
        this.swimTime = swimTime;
    }

    public void syncSwimming() {
        NetworkHandler.INSTANCE.sendToServer((Object)new SwimPacket(this.shouldSwim));
    }

    public void syncSinking(ServerPlayer player) {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SinkPacket(this.shouldSink));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128379_("ShouldSwim", this.isSwimming());
        compoundNBT.m_128379_("ShouldSink", this.isSinking());
        compoundNBT.m_128379_("IsWet", this.isWet());
        compoundNBT.m_128405_("SwimTime", this.getSwimTime());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSwimming(nbt.m_128471_("ShouldSwim"));
        this.setSinking(nbt.m_128471_("ShouldSink"));
        this.setWet(nbt.m_128471_("IsWet"));
        this.setSwimTime(nbt.m_128451_("SwimTime"));
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(SwimHandler::onRegisterCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, SwimHandler::onAttachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(SwimHandler::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(SwimHandler::onPlayerSwim);
    }

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(SwimHandler.class);
    }

    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            SwimHandlerProvider provider = new SwimHandlerProvider();
            event.addCapability(Artifacts.id("swim_handler"), (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    public static void onPlayerSwim(PlayerSwimEvent event) {
        event.getEntity().getCapability(CAPABILITY).ifPresent(handler -> {
            if (event.getResult() == Event.Result.DEFAULT) {
                if (handler.isSwimming()) {
                    event.setResult(Event.Result.ALLOW);
                } else if (handler.isSinking()) {
                    event.setResult(Event.Result.DENY);
                }
            }
        });
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.getCapability(CAPABILITY).ifPresent(handler -> {
            if (event.player.m_20069_() || event.player.m_20077_()) {
                if (!handler.isWet()) {
                    handler.setWet(true);
                }
            } else if (event.player.m_20096_() || event.player.m_150110_().f_35935_) {
                handler.setWet(false);
            }
        });
    }
}

