/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.Artifacts;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.PlayLevelSoundEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class HurtSoundEventHandler {
    private static final Map<WearableArtifactItem, SoundEvent> HURT_SOUNDS = new HashMap<WearableArtifactItem, SoundEvent>();

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(HurtSoundEventHandler::onPlaySoundAtEntity);
        HURT_SOUNDS.put((WearableArtifactItem)((Object)ModItems.BUNNY_HOPPERS.get()), SoundEvents.f_12353_);
        HURT_SOUNDS.put((WearableArtifactItem)((Object)ModItems.KITTY_SLIPPERS.get()), SoundEvents.f_11791_);
    }

    public static void onPlaySoundAtEntity(PlayLevelSoundEvent.AtEntity event) {
        Object object;
        boolean canModifySound;
        boolean bl = canModifySound = Artifacts.CONFIG.client.modifyHurtSounds && event.getSound() != null && HurtSoundEventHandler.isHurtSound((SoundEvent)event.getSound().get());
        if (canModifySound && (object = event.getEntity()) instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)object;
            for (WearableArtifactItem item : HURT_SOUNDS.keySet()) {
                if (!CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)item).isPresent()) continue;
                HurtSoundEventHandler.playHurtSound(entity, item, event.getSource());
            }
        }
    }

    private static void playHurtSound(LivingEntity entity, WearableArtifactItem item, SoundSource source) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float pitch = (entity.m_217043_().m_188501_() - entity.m_217043_().m_188501_()) * 0.2f + 1.0f;
        entity.m_20193_().m_7785_(x, y, z, HURT_SOUNDS.get((Object)item), source, 1.0f, pitch, false);
    }

    private static boolean isHurtSound(SoundEvent event) {
        return event == SoundEvents.f_12323_ || event == SoundEvents.f_12324_ || event == SoundEvents.f_12273_ || event == SoundEvents.f_12274_;
    }
}

