/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.capability.SwimHandler;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.item.wearable.belt.CloudInABottleItem;
import artifacts.network.DoubleJumpPacket;
import artifacts.network.NetworkHandler;
import artifacts.network.ToggleArtifactPacket;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class InputEventHandler {
    private static boolean wasSprintKeyDown;
    private static boolean wasSprintingOnGround;
    private static boolean hasTouchedGround;
    private static boolean canDoubleJump;
    private static boolean hasReleasedJumpKey;
    private static final Map<WearableArtifactItem, KeyMapping> TOGGLE_KEY_MAPPINGS;

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(InputEventHandler::onClientTick);
        InputEventHandler.addToggleInputHandler((WearableArtifactItem)((Object)ModItems.NIGHT_VISION_GOGGLES.get()), ModKeyMappings.TOGGLE_NIGHT_VISION_GOGGLES);
        InputEventHandler.addToggleInputHandler((WearableArtifactItem)((Object)ModItems.UNIVERSAL_ATTRACTOR.get()), ModKeyMappings.TOGGLE_UNIVERSAL_ATTRACTOR);
    }

    public static KeyMapping getToggleKey(WearableArtifactItem item) {
        return TOGGLE_KEY_MAPPINGS.get((Object)item);
    }

    private static void addToggleInputHandler(WearableArtifactItem item, KeyMapping toggleKey) {
        TOGGLE_KEY_MAPPINGS.put(item, toggleKey);
        ToggleInputHandler handler = new ToggleInputHandler(item);
        MinecraftForge.EVENT_BUS.addListener(handler::onClientTick);
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.phase == TickEvent.Phase.END && player != null && player.f_108618_ != null) {
            InputEventHandler.handleCloudInABottleInput(player);
            InputEventHandler.handleHeliumFlamingoInput((Player)player);
        }
    }

    private static void handleCloudInABottleInput(LocalPlayer player) {
        if ((player.m_20096_() || player.m_6147_()) && !player.m_20069_()) {
            hasReleasedJumpKey = false;
            canDoubleJump = true;
        } else if (!player.f_108618_.f_108572_) {
            hasReleasedJumpKey = true;
        } else if (!player.m_150110_().f_35935_ && canDoubleJump && hasReleasedJumpKey) {
            canDoubleJump = false;
            if (((CloudInABottleItem)((Object)ModItems.CLOUD_IN_A_BOTTLE.get())).isEquippedBy((LivingEntity)player)) {
                NetworkHandler.INSTANCE.sendToServer((Object)new DoubleJumpPacket());
                CloudInABottleItem.jump((Player)player);
            }
        }
    }

    private static void handleHeliumFlamingoInput(Player player) {
        if (ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() <= 0) {
            return;
        }
        boolean isSprintKeyDown = ModKeyMappings.getHeliumFlamingoKey().m_90857_();
        player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
            if (!handler.isSwimming()) {
                if (player.m_20096_()) {
                    hasTouchedGround = true;
                } else if (InputEventHandler.canActivateHeliumFlamingo(handler, player, isSprintKeyDown)) {
                    handler.setSwimming(true);
                    handler.syncSwimming();
                    hasTouchedGround = false;
                }
            } else if (player.m_150110_().f_35935_) {
                handler.setSwimming(false);
                handler.syncSwimming();
                hasTouchedGround = true;
            }
        });
        wasSprintKeyDown = isSprintKeyDown;
        if (!isSprintKeyDown) {
            wasSprintingOnGround = false;
        } else if (player.m_20096_()) {
            wasSprintingOnGround = true;
        }
    }

    private static boolean canActivateHeliumFlamingo(SwimHandler handler, Player player, boolean isSprintKeyDown) {
        if (handler.isSwimming() || handler.getSwimTime() < 0 || !((WearableArtifactItem)((Object)ModItems.HELIUM_FLAMINGO.get())).isEquippedBy((LivingEntity)player)) {
            return false;
        }
        if (player.m_6069_()) {
            return true;
        }
        return isSprintKeyDown && !wasSprintKeyDown && !wasSprintingOnGround && hasTouchedGround && !player.m_20096_() && (!player.m_20069_() || handler.isSinking()) && !player.m_21255_() && !player.m_150110_().f_35935_ && !player.m_20159_();
    }

    static {
        TOGGLE_KEY_MAPPINGS = new HashMap<WearableArtifactItem, KeyMapping>();
    }

    private static class ToggleInputHandler {
        private boolean wasToggleKeyDown;
        private final WearableArtifactItem item;

        public ToggleInputHandler(WearableArtifactItem item) {
            this.item = item;
        }

        public void onClientTick(TickEvent.ClientTickEvent event) {
            boolean isToggleKeyDown = InputEventHandler.getToggleKey(this.item).m_90857_();
            if (isToggleKeyDown && !this.wasToggleKeyDown) {
                NetworkHandler.INSTANCE.sendToServer((Object)new ToggleArtifactPacket(this.item));
            }
            this.wasToggleKeyDown = isToggleKeyDown;
        }
    }
}

