/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.renderer;

import artifacts.Artifacts;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.client.ForgeRenderTypes;

public class GlowingGloveArtifactRenderer
extends GloveArtifactRenderer {
    private final ResourceLocation defaultGlowTexture;
    private final ResourceLocation slimGlowTexture;

    public GlowingGloveArtifactRenderer(String name, ArmsModel defaultModel, ArmsModel slimModel) {
        super(name, defaultModel, slimModel);
        this.defaultGlowTexture = Artifacts.id("textures/entity/curio/glove/%s/%s_default_glow.png", name, name);
        this.slimGlowTexture = Artifacts.id("textures/entity/curio/glove/%s/%s_slim_glow.png", name, name);
    }

    private ResourceLocation getGlowTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimGlowTexture : this.defaultGlowTexture;
    }

    @Override
    protected void renderArm(ArmsModel model, PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm armSide, int light, boolean hasSlimArms, boolean hasFoil) {
        super.renderArm(model, poseStack, multiBufferSource, armSide, light, hasSlimArms, hasFoil);
        RenderType renderType = ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getGlowTexture(hasSlimArms));
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        model.renderArm(armSide, poseStack, builder, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    protected void renderFirstPersonArm(ArmsModel model, ModelPart arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, boolean hasSlimArms, boolean hasFoil) {
        super.renderFirstPersonArm(model, arm, poseStack, multiBufferSource, light, hasSlimArms, hasFoil);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getGlowTexture(hasSlimArms)), (boolean)false, (boolean)hasFoil);
        arm.m_104301_(poseStack, builder, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
    }
}

