/*
 * Decompiled with CFR 0.152.
 */
package artifacts.data;

import artifacts.Artifacts;
import artifacts.data.LootTables;
import artifacts.loot.ConfigurableRandomChance;
import artifacts.loot.RollLootTableModifier;
import artifacts.registry.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class LootModifiers
extends GlobalLootModifierProvider {
    protected List<Builder> lootBuilders = new ArrayList<Builder>();

    public LootModifiers(PackOutput packOutput) {
        super(packOutput, "artifacts");
    }

    private void addLoot() {
        this.lootBuilders.add(new Builder("entities/cow").lootPoolCondition(LootItemRandomChanceCondition.m_81927_((float)0.002f)).lootModifierCondition((LootItemCondition.Builder)LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("entities/cow"))).parameterSet(LootContextParamSets.f_81415_).lootPoolCondition(LootItemKilledByPlayerCondition.m_81901_()).everlastingBeef());
        for (String biome : Arrays.asList("desert", "plains", "savanna", "snowy", "taiga")) {
            this.builder(String.format("chests/village/village_%s_house", biome), 0.02f).item((Item)ModItems.VILLAGER_HAT.get());
        }
        this.builder("chests/spawn_bonus_chest", 1.0f).item((Item)ModItems.WHOOPEE_CUSHION.get());
        this.builder("chests/village/village_armorer", 0.1f).item((Item)ModItems.STEADFAST_SPIKES.get()).item((Item)ModItems.SUPERSTITIOUS_HAT.get()).item((Item)ModItems.RUNNING_SHOES.get()).item((Item)ModItems.VAMPIRIC_GLOVE.get());
        this.builder("chests/village/village_butcher", 0.05f).item((Item)ModItems.EVERLASTING_BEEF.get());
        this.builder("chests/village/village_tannery", 0.2f).item((Item)ModItems.UMBRELLA.get(), 3).item((Item)ModItems.WHOOPEE_CUSHION.get(), 2).item((Item)ModItems.KITTY_SLIPPERS.get()).item((Item)ModItems.BUNNY_HOPPERS.get()).item((Item)ModItems.SCARF_OF_INVISIBILITY.get());
        this.builder("chests/village/village_temple", 0.2f).item((Item)ModItems.CROSS_NECKLACE.get()).item((Item)ModItems.ANTIDOTE_VESSEL.get()).item((Item)ModItems.CHARM_OF_SINKING.get());
        this.builder("chests/village/village_toolsmith", 0.15f).item((Item)ModItems.DIGGING_CLAWS.get()).item((Item)ModItems.POCKET_PISTON.get());
        this.builder("chests/village/village_weaponsmith", 0.1f).item((Item)ModItems.FERAL_CLAWS.get());
        this.builder("chests/abandoned_mineshaft", 0.3f).item((Item)ModItems.NIGHT_VISION_GOGGLES.get()).item((Item)ModItems.PANIC_NECKLACE.get()).item((Item)ModItems.OBSIDIAN_SKULL.get()).item((Item)ModItems.SUPERSTITIOUS_HAT.get()).item((Item)ModItems.DIGGING_CLAWS.get()).item((Item)ModItems.CLOUD_IN_A_BOTTLE.get()).item((Item)ModItems.VAMPIRIC_GLOVE.get()).item((Item)ModItems.AQUA_DASHERS.get()).drinkingHat(1);
        this.builder("chests/bastion_hoglin_stable", 0.2f).artifact(5).item((Item)ModItems.BUNNY_HOPPERS.get(), 3).item((Item)ModItems.FLAME_PENDANT.get(), 3).item((Item)ModItems.EVERLASTING_BEEF.get());
        this.builder("chests/bastion_treasure", 0.65f).artifact(6).item((Item)ModItems.GOLDEN_HOOK.get(), 3).item((Item)ModItems.CROSS_NECKLACE.get(), 3).item((Item)ModItems.FIRE_GAUNTLET.get(), 2).item((Item)ModItems.STEADFAST_SPIKES.get()).item((Item)ModItems.PANIC_NECKLACE.get()).item((Item)ModItems.CRYSTAL_HEART.get()).item((Item)ModItems.ANTIDOTE_VESSEL.get());
        this.builder("chests/buried_treasure", 0.25f).item((Item)ModItems.SNORKEL.get(), 5).item((Item)ModItems.FLIPPERS.get(), 5).item((Item)ModItems.UMBRELLA.get(), 5).item((Item)ModItems.GOLDEN_HOOK.get(), 5).item((Item)ModItems.FERAL_CLAWS.get(), 3).item((Item)ModItems.DIGGING_CLAWS.get(), 3).item((Item)ModItems.KITTY_SLIPPERS.get(), 3).item((Item)ModItems.BUNNY_HOPPERS.get(), 3).item((Item)ModItems.LUCKY_SCARF.get(), 3).item((Item)ModItems.AQUA_DASHERS.get(), 3).drinkingHat(3);
        this.builder("chests/desert_pyramid", 0.2f).item((Item)ModItems.FLAME_PENDANT.get(), 2).item((Item)ModItems.THORN_PENDANT.get(), 2).item((Item)ModItems.WHOOPEE_CUSHION.get(), 2).item((Item)ModItems.CHARM_OF_SINKING.get(), 2).item((Item)ModItems.SHOCK_PENDANT.get()).item((Item)ModItems.UMBRELLA.get()).item((Item)ModItems.SCARF_OF_INVISIBILITY.get()).item((Item)ModItems.UNIVERSAL_ATTRACTOR.get()).item((Item)ModItems.VAMPIRIC_GLOVE.get());
        this.builder("chests/end_city_treasure", 0.3f).artifact(3).item((Item)ModItems.CRYSTAL_HEART.get()).item((Item)ModItems.CLOUD_IN_A_BOTTLE.get()).item((Item)ModItems.HELIUM_FLAMINGO.get(), 4);
        this.builder("chests/jungle_temple", 0.3f).item((Item)ModItems.KITTY_SLIPPERS.get(), 2).item((Item)ModItems.BUNNY_HOPPERS.get());
        this.builder("chests/nether_bridge", 0.15f).item((Item)ModItems.CROSS_NECKLACE.get()).item((Item)ModItems.NIGHT_VISION_GOGGLES.get()).item((Item)ModItems.POCKET_PISTON.get()).item((Item)ModItems.RUNNING_SHOES.get()).drinkingHat(1);
        this.builder("chests/pillager_outpost", 0.25f).item((Item)ModItems.PANIC_NECKLACE.get()).item((Item)ModItems.POCKET_PISTON.get()).item((Item)ModItems.STEADFAST_SPIKES.get()).item((Item)ModItems.POWER_GLOVE.get()).item((Item)ModItems.CROSS_NECKLACE.get()).item((Item)ModItems.SCARF_OF_INVISIBILITY.get()).item((Item)ModItems.CRYSTAL_HEART.get()).item((Item)ModItems.CLOUD_IN_A_BOTTLE.get()).item((Item)ModItems.SUPERSTITIOUS_HAT.get());
        this.builder("chests/ruined_portal", 0.15f).item((Item)ModItems.NIGHT_VISION_GOGGLES.get()).item((Item)ModItems.THORN_PENDANT.get()).item((Item)ModItems.FIRE_GAUNTLET.get()).item((Item)ModItems.POWER_GLOVE.get()).item((Item)ModItems.UNIVERSAL_ATTRACTOR.get()).item((Item)ModItems.OBSIDIAN_SKULL.get()).item((Item)ModItems.LUCKY_SCARF.get());
        this.builder("chests/shipwreck_treasure", 0.15f).item((Item)ModItems.GOLDEN_HOOK.get(), 3).item((Item)ModItems.SNORKEL.get()).item((Item)ModItems.FLIPPERS.get()).item((Item)ModItems.SCARF_OF_INVISIBILITY.get()).item((Item)ModItems.STEADFAST_SPIKES.get()).item((Item)ModItems.UNIVERSAL_ATTRACTOR.get()).item((Item)ModItems.FERAL_CLAWS.get()).item((Item)ModItems.NIGHT_VISION_GOGGLES.get()).item((Item)ModItems.OBSIDIAN_SKULL.get()).item((Item)ModItems.RUNNING_SHOES.get()).item((Item)ModItems.CHARM_OF_SINKING.get());
        this.builder("chests/stronghold_corridor", 0.3f).artifact(3).item((Item)ModItems.POWER_GLOVE.get()).item((Item)ModItems.ANTIDOTE_VESSEL.get()).item((Item)ModItems.SUPERSTITIOUS_HAT.get()).item((Item)ModItems.LUCKY_SCARF.get()).item((Item)ModItems.AQUA_DASHERS.get()).item((Item)ModItems.HELIUM_FLAMINGO.get());
        this.builder("chests/underwater_ruin_big", 0.45f).item((Item)ModItems.SNORKEL.get(), 3).item((Item)ModItems.FLIPPERS.get(), 3).item((Item)ModItems.SUPERSTITIOUS_HAT.get()).item((Item)ModItems.LUCKY_SCARF.get()).item((Item)ModItems.FIRE_GAUNTLET.get()).item((Item)ModItems.CROSS_NECKLACE.get()).item((Item)ModItems.POWER_GLOVE.get()).item((Item)ModItems.CLOUD_IN_A_BOTTLE.get());
        this.builder("chests/woodland_mansion", 0.25f).artifact(1);
    }

    protected Builder builder(String lootTable, float baseChance) {
        Builder builder = new Builder(lootTable);
        builder.lootPoolCondition(ConfigurableRandomChance.configurableRandomChance(baseChance));
        builder.lootModifierCondition((LootItemCondition.Builder)LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(lootTable)));
        this.lootBuilders.add(builder);
        return builder;
    }

    protected void start() {
        this.addLoot();
        for (Builder lootBuilder : this.lootBuilders) {
            this.add("inject/" + lootBuilder.lootTable, (IGlobalLootModifier)lootBuilder.build());
        }
    }

    protected static class Builder {
        private final String lootTable;
        private final LootPool.Builder lootPool = LootPool.m_79043_();
        private final List<LootItemCondition> conditions;
        private LootContextParamSet paramSet = LootContextParamSets.f_81411_;

        private Builder(String lootTable) {
            this.lootTable = lootTable;
            this.conditions = new ArrayList<LootItemCondition>();
        }

        private RollLootTableModifier build() {
            return new RollLootTableModifier(this.conditions.toArray(new LootItemCondition[0]), Artifacts.id("inject/%s", this.lootTable));
        }

        protected LootTable.Builder createLootTable() {
            return new LootTable.Builder().m_79161_(this.lootPool);
        }

        public LootContextParamSet getParameterSet() {
            return this.paramSet;
        }

        protected String getName() {
            return this.lootTable;
        }

        private Builder parameterSet(LootContextParamSet paramSet) {
            this.paramSet = paramSet;
            return this;
        }

        private Builder lootPoolCondition(LootItemCondition.Builder condition) {
            this.lootPool.m_79080_(condition);
            return this;
        }

        private Builder lootModifierCondition(LootItemCondition.Builder condition) {
            this.conditions.add(condition.m_6409_());
            return this;
        }

        private Builder item(Item item, int weight) {
            this.lootPool.m_79076_(LootTables.item(item, weight));
            return this;
        }

        private Builder item(Item item) {
            return this.item(item, 1);
        }

        private Builder artifact(int weight) {
            this.lootPool.m_79076_(LootTables.artifact(weight));
            return this;
        }

        private Builder drinkingHat(int weight) {
            this.lootPool.m_79076_(LootTables.drinkingHat(weight));
            return this;
        }

        private Builder everlastingBeef() {
            this.lootPool.m_79076_((LootPoolEntryContainer.Builder)LootTables.item((Item)ModItems.EVERLASTING_BEEF.get(), 1).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_())))));
            return this;
        }
    }
}

