/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.capability.SwimHandler;
import artifacts.item.ArtifactItem;
import artifacts.registry.ModGameRules;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingEvent;

public class UmbrellaItem
extends ArtifactItem {
    public static final AttributeModifier UMBRELLA_SLOW_FALLING = new AttributeModifier(UUID.fromString("a7a25453-2065-4a96-bc83-df600e13f390"), "artifacts:umbrella_slow_falling", -0.875, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public UmbrellaItem() {
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.UMBRELLA_IS_GLIDER.get() == false && ModGameRules.UMBRELLA_IS_SHIELD.get() == false;
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        if (ModGameRules.UMBRELLA_IS_GLIDER.get().booleanValue()) {
            tooltip.add(this.tooltipLine("glider", new Object[0]));
        }
        if (ModGameRules.UMBRELLA_IS_SHIELD.get().booleanValue()) {
            tooltip.add(this.tooltipLine("shield", new Object[0]));
        }
    }

    private void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        AttributeInstance gravity = entity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            boolean isInWater;
            boolean bl = isInWater = entity.m_20069_() && entity.getCapability(SwimHandler.CAPABILITY).map(SwimHandler::isSinking).orElse(false) == false;
            if (!(!ModGameRules.UMBRELLA_IS_GLIDER.get().booleanValue() || entity.m_20096_() || isInWater || !(event.getEntity().m_20184_().f_82480_ < 0.0) || entity.m_21023_(MobEffects.f_19591_) || entity.m_21206_().m_41720_() != this && entity.m_21205_().m_41720_() != this || entity.m_6117_() && !entity.m_21211_().m_41619_() && entity.m_21211_().m_41720_().m_6164_(entity.m_21211_()) == UseAnim.BLOCK)) {
                if (!gravity.m_22109_(UMBRELLA_SLOW_FALLING)) {
                    gravity.m_22118_(UMBRELLA_SLOW_FALLING);
                }
                entity.f_19789_ = 0.0f;
            } else if (gravity.m_22109_(UMBRELLA_SLOW_FALLING)) {
                gravity.m_22130_(UMBRELLA_SLOW_FALLING);
            }
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction) && ModGameRules.UMBRELLA_IS_SHIELD.get() != false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.canPerformAction(stack, ToolActions.SHIELD_BLOCK)) {
            return super.m_7203_(level, player, hand);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity, InteractionHand hand) {
        return entity.m_21120_(hand).m_41720_() instanceof UmbrellaItem && (!entity.m_6117_() || entity.m_7655_() != hand);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity) {
        return UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.MAIN_HAND) || UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.OFF_HAND);
    }
}

