/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.Artifacts;
import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public abstract class AttributeModifyingItem
extends WearableArtifactItem {
    private final Attribute attribute;
    protected final UUID modifierId;
    protected final String modifierName;

    public AttributeModifyingItem(Attribute attribute, UUID modifierId, String modifierName) {
        this.attribute = attribute;
        this.modifierId = modifierId;
        this.modifierName = modifierName;
    }

    @Override
    protected boolean isCosmetic() {
        return this.getAmount() <= 0.0;
    }

    private AttributeModifier createModifier() {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount(), AttributeModifier.Operation.ADDITION);
    }

    protected abstract double getAmount();

    protected void onAttributeUpdated(LivingEntity entity) {
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        AttributeInstance attributeInstance;
        super.onEquip(slotContext, originalStack, newStack);
        if (!slotContext.entity().f_19853_.m_5776_() && (attributeInstance = slotContext.entity().m_21051_(this.attribute)) != null) {
            attributeInstance.m_22120_(this.modifierId);
            AttributeModifier modifier = this.createModifier();
            attributeInstance.m_22125_(modifier);
            this.onAttributeUpdated(slotContext.entity());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AttributeModifier existingModifier;
        AttributeInstance attributeInstance;
        if (!(slotContext.entity().f_19853_.m_5776_() || (attributeInstance = slotContext.entity().m_21051_(this.attribute)) == null || (existingModifier = attributeInstance.m_22111_(this.modifierId)) != null && existingModifier.m_22218_() == this.getAmount())) {
            attributeInstance.m_22120_(this.modifierId);
            attributeInstance.m_22125_(this.createModifier());
            this.onAttributeUpdated(slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        AttributeInstance attributeInstance;
        if (!slotContext.entity().f_19853_.m_5776_() && (attributeInstance = slotContext.entity().m_21051_(this.attribute)) != null) {
            attributeInstance.m_22120_(this.modifierId);
            this.onAttributeUpdated(slotContext.entity());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
        Set curioTags = CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_());
        ArrayList slots = new ArrayList(curioTags);
        if (Artifacts.CONFIG.client.showTooltips && !this.isCosmetic() && !slots.isEmpty()) {
            tooltipList.add((Component)Component.m_237119_());
            String identifier = slots.contains("curio") ? "curio" : (String)slots.get(0);
            tooltipList.add((Component)Component.m_237115_((String)("curios.modifiers." + identifier)));
            tooltipList.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + AttributeModifier.Operation.ADDITION.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(this.getAmount()), Component.m_237115_((String)this.attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
        }
    }
}

