/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.client.InputEventHandler;
import artifacts.item.ArtifactItem;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class WearableArtifactItem
extends ArtifactItem
implements ICurioItem {
    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return entity != null && CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)this).isPresent();
    }

    protected <T extends Event, S extends LivingEntity> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        MinecraftForge.EVENT_BUS.addListener(priority, true, eventClass, event -> {
            LivingEntity wearer = (LivingEntity)wearerSupplier.apply(event);
            if (this.isEquippedBy(wearer)) {
                listener.accept(event, wearer);
            }
        });
    }

    protected <T extends Event, S extends LivingEntity> void addListener(Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        this.addListener(EventPriority.NORMAL, eventClass, listener, wearerSupplier);
    }

    protected <T extends LivingEvent> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(priority, eventClass, listener, LivingEvent::getEntity);
    }

    protected <T extends LivingEvent> void addListener(Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(EventPriority.NORMAL, eventClass, listener);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!WearableArtifactItem.isActivated(stack) && prevStack.m_41720_() != this && !slotContext.entity().f_19853_.m_5776_()) {
            WearableArtifactItem.setActivated(stack, true);
        }
    }

    public void toggleItem(ServerPlayer player) {
        for (SlotResult curio : CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)this)) {
            WearableArtifactItem.setActivated(curio.stack(), !WearableArtifactItem.isActivated(curio.stack()));
        }
    }

    public static boolean isActivated(ItemStack stack) {
        return !stack.m_41782_() || stack.m_41784_().m_128471_("isActivated");
    }

    public static void setActivated(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("isActivated", active);
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        super.addEffectsTooltip(tooltip);
        KeyMapping key = InputEventHandler.getToggleKey(this);
        if (key != null && !key.m_90862_()) {
            tooltip.add(Component.m_237110_((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{InputEventHandler.getToggleKey(this).m_90863_()}));
        }
    }
}

