/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CloudInABottleItem
extends WearableArtifactItem {
    public CloudInABottleItem() {
        this.addListener(EventPriority.HIGHEST, LivingFallEvent.class, this::onLivingFall);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.CLOUD_IN_A_BOTTLE_ENABLED.get() == false;
    }

    public static void jump(Player player) {
        player.f_19789_ = 0.0f;
        double upwardsMotion = 0.5;
        if (player.m_21023_(MobEffects.f_19603_)) {
            upwardsMotion += 0.1 * (double)(player.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
        }
        Vec3 motion = player.m_20184_();
        double motionMultiplier = player.m_20142_() ? Math.max(0.0, (double)ModGameRules.CLOUD_IN_A_BOTTLE_SPRINT_JUMP_HORIZONTAL_VELOCITY.get().intValue() / 100.0) : 0.0;
        float direction = (float)((double)player.m_146908_() * Math.PI / 180.0);
        player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)direction)) * motionMultiplier, (upwardsMotion *= player.m_20142_() ? 1.0 + Math.max(0.0, (double)ModGameRules.CLOUD_IN_A_BOTTLE_SPRINT_JUMP_VERTICAL_VELOCITY.get().intValue() / 100.0) : 1.0) - motion.f_82480_, (double)Mth.m_14089_((float)direction) * motionMultiplier));
        player.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)player);
        player.m_36220_(Stats.f_12926_);
        if (player.m_20142_()) {
            player.m_36399_(0.2f);
        } else {
            player.m_36399_(0.05f);
        }
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.WHOOPEE_CUSHION.get()).isPresent()) {
            player.m_5496_((SoundEvent)ModSoundEvents.FART.get(), 1.0f, 0.9f + player.m_217043_().m_188501_() * 0.2f);
        } else {
            player.m_5496_(SoundEvents.f_12640_, 1.0f, 0.9f + player.m_217043_().m_188501_() * 0.2f);
        }
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        if (ModGameRules.CLOUD_IN_A_BOTTLE_ENABLED.get().booleanValue()) {
            event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11771_, 1.0f, 1.0f);
    }
}

