/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.capability.SwimHandler;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModKeyMappings;
import artifacts.registry.ModSoundEvents;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidType;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class HeliumFlamingoItem
extends WearableArtifactItem {
    public HeliumFlamingoItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() <= 0;
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        tooltip.add(this.tooltipLine("swimming", new Object[0]));
        tooltip.add(this.tooltipLine("keymapping", ModKeyMappings.getHeliumFlamingoKey().m_90863_()));
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo((SoundEvent)ModSoundEvents.POP.get(), 1.0f, 0.7f);
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
            int maxFlightTime = Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() * 20);
            int rechargeTime = Math.max(20, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get() * 20);
            if (handler.isSwimming()) {
                if (!this.isEquippedBy((LivingEntity)event.player) || handler.getSwimTime() > maxFlightTime || event.player.m_20069_() && !event.player.m_6069_() && !handler.isSinking() || (!event.player.m_20069_() || handler.isSinking()) && event.player.m_20096_()) {
                    handler.setSwimming(false);
                    if (!event.player.m_20096_() && !event.player.m_20069_()) {
                        event.player.m_5496_((SoundEvent)ModSoundEvents.POP.get(), 0.5f, 0.75f);
                    }
                }
                if (this.isEquippedBy((LivingEntity)event.player) && !event.player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !event.player.m_150110_().f_35934_) {
                    handler.setSwimTime(handler.getSwimTime() + 1);
                }
            } else if (handler.getSwimTime() < 0) {
                handler.setSwimTime(handler.getSwimTime() < -rechargeTime ? -rechargeTime : handler.getSwimTime() + 1);
            }
        });
    }
}

