/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.feet;

import artifacts.capability.SwimHandler;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import be.florens.expandability.api.forge.LivingFluidCollisionEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.eventbus.api.Event;

public class AquaDashersItem
extends WearableArtifactItem {
    public AquaDashersItem() {
        this.addListener(LivingFluidCollisionEvent.class, this::onFluidCollision);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.AQUA_DASHERS_ENABLED.get() == false;
    }

    private void onFluidCollision(LivingFluidCollisionEvent event, LivingEntity wearer) {
        if (ModGameRules.AQUA_DASHERS_ENABLED.get().booleanValue() && wearer.m_20142_() && wearer.f_19789_ < 6.0f && !wearer.m_6117_() && !wearer.m_6047_()) {
            wearer.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                if (!handler.isWet() && !handler.isSwimming()) {
                    event.setResult(Event.Result.ALLOW);
                    if (event.getFluidState().m_205070_(FluidTags.f_13132_) && !wearer.m_5825_() && !EnchantmentHelper.m_44938_((LivingEntity)wearer)) {
                        wearer.m_6469_(wearer.m_269291_().m_269047_(), 1.0f);
                    }
                }
            });
        }
    }

    public boolean isSprinting(LivingEntity entity) {
        return this.isEquippedBy(entity) && ModGameRules.AQUA_DASHERS_ENABLED.get() != false && entity.m_20142_() && entity.f_19789_ < 6.0f && entity.getCapability(SwimHandler.CAPABILITY).map(SwimHandler::isWet).orElse(true) == false;
    }
}

