/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModTags;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DiggingClawsItem
extends WearableArtifactItem {
    public DiggingClawsItem() {
        this.addListener(EventPriority.LOW, PlayerEvent.BreakSpeed.class, this::onBreakSpeed);
        this.addListener(PlayerEvent.HarvestCheck.class, this::onHarvestCheck);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.DIGGING_CLAWS_TOOL_TIER.get() <= 0 && ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() <= 0;
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        int tierLevel = this.getToolTierLevel();
        if (tierLevel > 0) {
            tooltip.add(this.tooltipLine("mining_level", Component.m_237115_((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tierLevel))));
        }
        if (ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() > 0) {
            tooltip.add(this.tooltipLine("mining_speed", new Object[0]));
        }
    }

    private boolean canHarvest(BlockState state) {
        Tier tier = this.getToolTier();
        return tier != null && TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state) && state.m_204336_(ModTags.MINEABLE_WITH_DIGGING_CLAWS);
    }

    private int getToolTierLevel() {
        return Math.min(5, Math.max(0, ModGameRules.DIGGING_CLAWS_TOOL_TIER.get()));
    }

    private Tier getToolTier() {
        return switch (this.getToolTierLevel()) {
            case 0 -> null;
            case 1 -> Tiers.WOOD;
            case 2 -> Tiers.STONE;
            case 3 -> Tiers.IRON;
            case 4 -> Tiers.DIAMOND;
            default -> Tiers.NETHERITE;
        };
    }

    private void onBreakSpeed(PlayerEvent.BreakSpeed event, LivingEntity wearer) {
        Player player;
        if (!(wearer instanceof Player) || (player = (Player)wearer).m_36298_(event.getState())) {
            float speedBonus = Math.max(0.0f, (float)ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get().intValue() / 10.0f);
            event.setNewSpeed(event.getNewSpeed() + speedBonus);
        }
    }

    private void onHarvestCheck(PlayerEvent.HarvestCheck event, LivingEntity wearer) {
        if (!event.canHarvest()) {
            event.setCanHarvest(this.canHarvest(event.getTargetBlock()));
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11679_, 1.0f, 1.0f);
    }
}

