/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;

public class GoldenHookItem
extends WearableArtifactItem {
    public GoldenHookItem() {
        this.addListener(LivingExperienceDropEvent.class, this::onLivingExperienceDrop, LivingExperienceDropEvent::getAttackingPlayer);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.GOLDEN_HOOK_EXPERIENCE_BONUS.get() <= 0;
    }

    private void onLivingExperienceDrop(LivingExperienceDropEvent event, LivingEntity wearer) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        int experienceBonus = (int)((float)(event.getOriginalExperience() * ModGameRules.GOLDEN_HOOK_EXPERIENCE_BONUS.get()) / 100.0f);
        if (experienceBonus > 0) {
            event.setDroppedExperience(event.getDroppedExperience() + experienceBonus);
        }
    }
}

