/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.capability.SwimHandler;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidType;
import top.theillusivec4.curios.api.SlotContext;

public class CharmOfSinkingItem
extends WearableArtifactItem {
    public CharmOfSinkingItem() {
        this.addListener(EventPriority.HIGH, PlayerEvent.BreakSpeed.class, this::onBreakSpeed);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.CHARM_OF_SINKING_ENABLED.get() == false;
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed event, LivingEntity wearer) {
        if (ModGameRules.CHARM_OF_SINKING_ENABLED.get().booleanValue() && wearer.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)wearer)) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            slotContext.entity().getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                if (ModGameRules.CHARM_OF_SINKING_ENABLED.get().booleanValue()) {
                    if (!handler.isSinking()) {
                        handler.setSinking(true);
                        handler.syncSinking(player);
                    }
                } else if (handler.isSinking()) {
                    handler.setSinking(false);
                    handler.syncSinking(player);
                }
            });
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            slotContext.entity().getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                handler.setSinking(false);
                handler.syncSinking(player);
            });
        }
    }
}

