/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.necklace.PendantItem;
import artifacts.registry.ModGameRules;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ShockPendantItem
extends PendantItem {
    public ShockPendantItem() {
        super(ModGameRules.SHOCK_PENDANT_STRIKE_CHANCE);
        this.addListener(LivingHurtEvent.class, this::onLivingHurt);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.SHOCK_PENDANT_STRIKE_CHANCE.get() <= 0 && ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get() == false;
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        if (ModGameRules.SHOCK_PENDANT_STRIKE_CHANCE.get() > 0) {
            tooltip.add(this.tooltipLine("strike_chance", new Object[0]));
        }
        if (ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get().booleanValue()) {
            tooltip.add(this.tooltipLine("lightning_damage", new Object[0]));
        }
    }

    private void onLivingHurt(LivingHurtEvent event, LivingEntity wearer) {
        if (!event.getEntity().f_19853_.m_5776_() && ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get().booleanValue() && event.getAmount() > 0.0f && event.getSource().m_269533_(DamageTypeTags.f_268725_)) {
            event.setCanceled(true);
        }
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        LightningBolt lightningBolt;
        if (attacker.f_19853_.m_45527_(BlockPos.m_274446_((Position)attacker.m_20182_())) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.f_19853_)) != null) {
            ServerPlayer player;
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)attacker.m_20183_()));
            lightningBolt.m_20879_(attacker instanceof ServerPlayer ? (player = (ServerPlayer)attacker) : null);
            attacker.f_19853_.m_7967_((Entity)lightningBolt);
        }
    }
}

