unit DXTexMat;



// Texture and Material functions for DirectX 3D   version of DX 6.0
// file version 1.0 Beta
// ACR '2000
// JPEG release
// Debug info inserted



interface
uses DirectX,classes,graphics,JPEG,Windows,SysUtils,Gdebug;


type

      PTexInfo = ^TTexInfo;
      TTexInfo = record
              tsurf : IDirectDrawSurface4;
              tex   : IDirect3DTexture2;
              hTex  : TD3DTextureHandle;   //not used in DX 6.0
              c     : TCanvas;
             end;



        PMatInfo = ^TMatInfo;
        TMatInfo = record
              Mat   : IDIRECT3DMATERIAL3;
              hMat  : TD3DMATERIALHANDLE;
             end;




      TDXTexture = Class
         TextureList :TList;
         uddi        :IDirectDraw4;


         function CreateTexture(w,h :Integer):Boolean;
         function LoadTexture(Item:Integer;FileName:String):Boolean;
         procedure DeleteTexture(Item:Integer);

         function GetTex(Item:Integer):IDirect3DTexture2;
         function GetTexSurf(Item:Integer):IDirectDrawSurface4;

         function GetCanvas(Item:Integer):TCanvas;
         procedure ReleaseCanvas(Item:Integer);

         procedure DeleteTexturesALL;

         constructor Create(ddinterf:IDirectDraw4);
         destructor Destroy;override;

      end;




      TDXMaterial = Class
         MaterialList :TList;
         ud3di        :IDirect3D3;

         function CreateMaterial:Boolean;
         procedure SetMaterial(Item:Integer;ud3ddevice : IDirect3DDevice3;dif_r,dif_g,dif_b,dif_a,
                                                                          am_r ,am_g ,am_b ,am_a,
                                                                          sp_r ,sp_g ,sp_b ,sp_a,
                                                                          em_r ,em_g ,em_b ,em_a,
                                                                          Pover: TD3DValue; RampSize: Integer);

         function GetMat(Item:Integer):TD3DMATERIALHANDLE;
         procedure DeleteMaterial(Item:Integer);
         procedure DeleteMaterialsALL;

         constructor Create(d3dinterf:IDirect3D3);
         destructor Destroy;override;

      end;


      TDXLight = Class
         LightList :TList;
         ud3di        :IDirect3D3;


         function CreateLight:Boolean;
         procedure SetLight(Item:Integer;LType:TD3DLightType;R,G,B,A,PX,PY,PZ,DX,DY,DZ,A0,A1,A2,Range,Falloff,Theta,Phi:Single);
         procedure AddToView(Item:Integer;d3dviewport : IDirect3DViewport3);
         procedure DelFromView(Item:Integer;d3dviewport : IDirect3DViewport3);

         procedure DeleteLight(Item:Integer);

         procedure DeleteLightsALL;

         constructor Create(d3dinterf:IDirect3D3);
         destructor Destroy;override;

      end;









procedure CreateCub(x,y,z,w,d,h:Single;Color:Integer;var mas:array of TD3DLVertex);

procedure CreatePlosDir(x,y,z,w,h,r:Single;Color:Integer;var mas:array of TD3DTLVertex);







var
         ddsd : TDDSURFACEDESC2;
         err : HRESULT;

implementation



function TDXTexture.CreateTexture(w,h:Integer):Boolean;
var pinfo : PTexInfo;
begin
    Result:=False;
    if uddi = nil then Exit;

    new(pinfo);
    pinfo.tsurf:=nil;
    pinfo.tex:=  nil;
    pinfo.hTex:= 0;
    pinfo.c:=nil;


    ZeroMemory( @ddsd, SizeOf( ddsd ));
     With ddsd do begin
          dwSize := SizeOf( ddsd );
          dwFlags :=
            DDSD_CAPS or
            DDSD_WIDTH or
            DDSD_HEIGHT;
          dwWidth:=w;
          dwHeight:=h;
          ddsCaps.dwCaps :=
            DDSCAPS_TEXTURE or
            DDSCAPS_VIDEOMEMORY;

        end;

    dbg_logmes('Create Texture surface',0);
    err:=uddi.CreateSurface(ddsd,pinfo.tsurf,nil);
    if err<> dd_ok then
       begin
           dbg_logerr(DXErrorString(err),0);

           ZeroMemory( @ddsd, SizeOf( ddsd ));
           With ddsd do begin
             dwSize := SizeOf( ddsd );
             dwFlags :=
               DDSD_CAPS or
               DDSD_WIDTH or
               DDSD_HEIGHT;
             dwWidth:=w;
             dwHeight:=h;
             ddsCaps.dwCaps :=
             DDSCAPS_TEXTURE or
             DDSCAPS_SYSTEMMEMORY;

           end;

           err:=uddi.CreateSurface(ddsd,pinfo.tsurf,nil);
           if err<> dd_ok then
               begin
                  dbg_logerr(DXErrorString(err),0);
                  Dispose(pinfo);
                  exit;
               end;
       end;


     dbg_logmes('QueryInterface to texture',0);
     err:= pinfo.tsurf.QueryInterface(iid_idirect3dtexture2,pinfo.tex);
     if err<> dd_ok then
               begin
                  dbg_logerr(DXErrorString(err),0);
                  pinfo.tsurf.Release;
                  Dispose(pinfo);
                  exit;
               end;


  {     Not USE in DX 6.0 ???????
     dbg_logmes('Get Texture Handle',0);
     err:= pinfo.tex.GetHandle(Pointer(d3ddevice),pinfo.htex);
     if err<> dd_ok then
               begin
                  dbg_logerr(DXErrorString(err),0);
                  pinfo.tex.Release;
                  pinfo.tsurf.Release;
                  Dispose(pinfo);
                  exit;
               end;
    }


    TextureList.Add(pinfo);
    Result:=True;
end;


function TDXTexture.LoadTexture(Item:Integer;FileName:String):Boolean;
var pinfo : PTexInfo;
    image : TJPEGImage;
    b     : graphics.TBitMap;
    tdc   : HDC;
begin
Result:=False;
if (Item<0) or (Item >= TextureList.Count) then exit;
if not fileexists(FileName) then exit;

image := TJPEGImage.Create;
b     := graphics.TBitMap.Create;

try
  image.LoadFromFile(FileName);
except
  image.Free;
  b.Free;
  exit;
end;


image.DIBNeeded;
b.Assign(image);
image.Free;

pinfo:=TextureList.Items[Item];

pinfo.tsurf.GetDC(tdc);
pinfo.c:=TCanvas.Create;
pinfo.c.handle:=tdc;
pinfo.c.Draw(0,0,b);
pinfo.tsurf.ReleaseDC(tdc);
pinfo.c.Free;
pinfo.c:=nil;
b.free;

Result:=True;

end;



procedure TDXTexture.DeleteTexture(Item:Integer);
var
     pinfo:PTexInfo;
begin

if (Item<0) or (Item >= TextureList.Count) then exit;
pinfo:=TextureList.Items[Item];
pinfo.tex.Release;
pinfo.tsurf.Release;
if pinfo.c <> nil then pinfo.c.Free;
Dispose(pinfo);

TextureList.Delete(Item);

end;



function TDXTexture.GetTex(Item:Integer):IDirect3DTexture2;
begin
  Result:=PTexInfo(TextureList.Items[Item]).tex;
end;

function TDXTexture.GetTexSurf(Item:Integer):IDirectDrawSurface4;
begin
 result:=nil;
 if (Item<0) or (Item >= TextureList.Count) then exit;
 Result:=PTexInfo(TextureList.Items[Item]).tsurf;
end;



function TDXTexture.GetCanvas(Item:Integer):TCanvas;
var tdc: HDC;
begin
 result:=nil;
 if (Item<0) or (Item >= TextureList.Count) then exit;
 if  PTexInfo(TextureList.Items[Item]).c <> nil then
   begin
     Result:=PTexInfo(TextureList.Items[Item]).c;
     exit;
   end;

 PTexInfo(TextureList.Items[Item]).tsurf.GetDC(tdc);
 PTexInfo(TextureList.Items[Item]).c:=TCanvas.Create;
 PTexInfo(TextureList.Items[Item]).c.Handle:=tdc;

 Result:=PTexInfo(TextureList.Items[Item]).c;
end;


procedure TDXTexture.ReleaseCanvas(Item:Integer);
begin
 if (Item<0) or (Item >= TextureList.Count) then exit;
 if  PTexInfo(TextureList.Items[Item]).c = nil then exit;


 PTexInfo(TextureList.Items[Item]).tsurf.ReleaseDC( PTexInfo(TextureList.Items[Item]).c.Handle);
 PTexInfo(TextureList.Items[Item]).c.Free;
 PTexInfo(TextureList.Items[Item]).c:=nil;
end;


procedure TDXTexture.DeleteTexturesALL;
var
     pinfo:PTexInfo;
     i    :Integer;
begin

i:=0;
while i<TextureList.Count do
 begin
   pinfo:=TextureList.Items[i];
   pinfo.tex.Release;
   pinfo.tsurf.Release;
   if pinfo.c <> nil then pinfo.c.Free;
   Dispose(pinfo);
   inc(i);
 end;

TextureList.Clear;
end;


constructor TDXTexture.Create(ddinterf:IDirectDraw4);
begin
inherited Create;

TextureList:= TList.Create;
uddi:=ddinterf;
end;

destructor TDXTexture.Destroy;
begin
DeleteTexturesALL;
TextureList.Free;

inherited;
end;




// Material =================================





function TDXMaterial.CreateMaterial:Boolean;
var pinfo : PMatInfo;
begin
    Result:=False;
    if ud3di = nil then Exit;

    new(pinfo);
    pinfo.mat:=nil;
    pinfo.hMat:= 0;

    dbg_logmes('Create Material Interface',0);
    err:=ud3di.CreateMaterial(pinfo.mat,nil);
    if err<> dd_ok then
          begin
               dbg_logerr(DXErrorString(err),0);
               Dispose(pinfo);
               exit;
          end;

    MaterialList.Add(pinfo);
    Result:=True;

end;


procedure TDXMaterial.SetMaterial(Item:Integer;ud3ddevice : IDirect3DDevice3;dif_r,dif_g,dif_b,dif_a,
                                                                            am_r ,am_g ,am_b ,am_a,
                                                                            sp_r ,sp_g ,sp_b ,sp_a,
                                                                            em_r ,em_g ,em_b ,em_a,
                                                                            Pover: TD3DValue; RampSize: Integer);
var Mat: TD3DMATERIAL;
begin
    if (Item<0) or (Item >= MaterialList.Count) then exit;


    ZeroMemory(@mat, sizeof(mat));
    mat.dwSize   := sizeof(mat);  // This is REQUIRED.

    // Set the RGBA for diffuse reflection.
    mat.dcvDiffuse.r := dif_r;
    mat.dcvDiffuse.g := dif_g;
    mat.dcvDiffuse.b := dif_b;
    mat.dcvDiffuse.a := dif_a;

    // Set the RGBA for ambient reflection.
    mat.dcvAmbient.r := am_r;
    mat.dcvAmbient.g := am_g;
    mat.dcvAmbient.b := am_b;
    mat.dcvAmbient.a := am_a;

    // Set the color and sharpness of specular highlights.
    mat.dcvSpecular.r := sp_r;
    mat.dcvSpecular.g := sp_g;
    mat.dcvSpecular.b := sp_b;
    mat.dcvSpecular.a := sp_a;

    mat.dcvEmissive.r := em_r;
    mat.dcvEmissive.g := em_g;
    mat.dcvEmissive.b := em_b;
    mat.dcvEmissive.a := em_a;


    mat.dvPower := Pover;

    // Use a 16 entry color ramp, in case
    // we're using ramp emulation.
    mat.dwRampSize := RampSize;

    dbg_logmes('Set Material Properties',0);
    err:=PMatInfo(MaterialList.Items[Item]).mat.SetMaterial(mat);
    if err<> dd_ok then
          begin
               dbg_logerr(DXErrorString(err),0);
               exit;
          end;

    dbg_logmes('Get Material Handle',0);
    err:=PMatInfo(MaterialList.Items[Item]).mat.GetHandle(ud3ddevice,PMatInfo(MaterialList.Items[Item]).hmat);
    if err<> dd_ok then
          begin
               dbg_logerr(DXErrorString(err),0);
               exit;
          end;
    dbg_logmes(' ',PMatInfo(MaterialList.Items[Item]).hmat);

end;



procedure TDXMaterial.DeleteMaterial(Item:Integer);
var
     pinfo:PMatInfo;
begin

if (Item<0) or (Item >= MaterialList.Count) then exit;
pinfo:=MaterialList.Items[Item];
pinfo.mat.Release;
Dispose(pinfo);
MaterialList.Delete(Item);
end;


procedure TDXMaterial.DeleteMaterialsALL;
var
     pinfo:PMatInfo;
     i    :Integer;
begin

i:=0;
while i<MaterialList.Count do
 begin
   pinfo:=MaterialList.Items[i];
   pinfo.mat.Release;
   Dispose(pinfo);
   inc(i);
 end;

MaterialList.Clear;
end;


function TDXMaterial.GetMat(Item:Integer):TD3DMATERIALHANDLE;
begin
Result:=0;
if (Item<0) or (Item >= MaterialList.Count) then exit;
Result:=PMatInfo(MaterialList.items[Item]).hmat;
dbg_logmes('GetMat = ', Result);
end;


constructor TDXMaterial.Create(d3dinterf:IDirect3D3);
begin
inherited Create;

MaterialList:= TList.Create;
ud3di       :=d3dinterf;
end;

destructor TDXMaterial.Destroy;
begin
DeleteMaterialsALL;
MaterialList.Free;

inherited;
end;






// TDXLight =---------------------------------------------------------------------------










function TDXLight.CreateLight:Boolean;
var
        lp3dLight :IDirect3DLight;
begin
Result:=False;

err:=ud3di.CreateLight(lp3dLight,nil);
if err<> dd_ok then
      begin
         dbg_logerr(DXErrorString(err),0);
         exit;
      end;

LightList.Add(lp3dLight);
Result:=True;

end;

procedure TDXLight.SetLight(Item:Integer;LType:TD3DLightType;R,G,B,A,PX,PY,PZ,DX,DY,DZ,A0,A1,A2,Range,Falloff,Theta,Phi:Single);
var
    d3dLight:TD3DLIGHT2;
begin
if (Item<0) or (Item >= LightList.Count) then exit;
ZeroMemory(@d3dLight, sizeof(d3dLight));
d3dLight.dwSize := sizeof(d3dLight);
d3dLight.dltType := LType;

d3dLight.dcvColor.dvR    := R;
d3dLight.dcvColor.dvG    := G;
d3dLight.dcvColor.dvB    := B;
d3dLight.dcvColor.dvA    := A;
d3dLight.dvPosition.dvX  := PX;
d3dLight.dvPosition.dvY  := PY;
d3dLight.dvPosition.dvZ  := PZ;
d3dLight.dvDirection.dvX := DX;
d3dLight.dvDirection.dvY := DY;
d3dLight.dvDirection.dvZ := DZ;
d3dLight.dvAttenuation0  := A0;
d3dLight.dvAttenuation1  := A1;
d3dLight.dvAttenuation2  := A2;
d3dLight.dvRange         := Range;
d3dLight.dvFalloff       := FallOff;
d3dLight.dvTheta         := Theta;
d3dLight.dvPhi           := Phi;
d3dLight.dwFlags         := D3DLIGHT_ACTIVE;


err := IDirect3DLight(LightList.Items[Item]).SetLight(d3dLight);
if err<> dd_ok then
      begin
         dbg_logerr(DXErrorString(err),0);
         exit;
      end;
end;




procedure TDXLight.AddToView(Item:Integer;d3dviewport : IDirect3DViewport3);
begin
if (Item<0) or (Item >= LightList.Count) then exit;

err:=d3dviewport.AddLight(LightList.Items[Item]);
if err<> dd_ok then
      begin
         dbg_logerr(DXErrorString(err),0);
         exit;
      end;

end;

procedure TDXLight.DelFromView(Item:Integer;d3dviewport : IDirect3DViewport3);
begin
if (Item<0) or (Item >= LightList.Count) then exit;

err:=d3dviewport.DeleteLight(LightList.Items[Item]);
if err<> dd_ok then
      begin
         dbg_logerr(DXErrorString(err),0);
         exit;
      end;

end;


procedure TDXLight.DeleteLight(Item:Integer);
begin
if (Item<0) or (Item >= LightList.Count) then exit;
IDirect3DLight(LightList.Items[Item]).Release;
LightList.Delete(Item);
end;


procedure TDXLight.DeleteLightsALL;
var
     i    :Integer;
begin

i:=0;
while i<LightList.Count do
 begin
   IDirect3DLight(LightList.Items[i]).Release;
   inc(i);
 end;

LightList.Clear;
end;


constructor TDXLight.Create(d3dinterf:IDirect3D3);
begin
inherited Create;

LightList:= TList.Create;
ud3di       :=d3dinterf;
end;

destructor TDXLight.Destroy;
begin
DeleteLightsALL;
LightList.Free;

inherited;
end;









procedure CreatePlosDir(x,y,z,w,h,r:Single;Color:Integer;var mas:array of TD3DTLVertex);
begin

mas[0].sx:= x;
mas[0].sy:= y;
mas[0].sz:= z;
mas[0].Color:= Color;
mas[0].rhw:=r;
mas[0].tu:=0;
mas[0].tv:=1;


mas[1].sx:= x;
mas[1].sy:= y - h;
mas[1].sz:= z;
mas[1].Color:= Color;
mas[1].rhw:=r;
mas[1].tu:=0;
mas[1].tv:=0;

mas[2].sx:= x + w;
mas[2].sy:= y;
mas[2].sz:= z;
mas[2].Color:= Color;
mas[2].rhw:=r;
mas[2].tu:=1;
mas[2].tv:=1;

mas[3].sx:= x + w;
mas[3].sy:= y - h;
mas[3].sz:= z;
mas[3].Color:= Color;
mas[3].rhw:=r;
mas[3].tu:=1;
mas[3].tv:=0;


end;





procedure CreateCub(x,y,z,w,d,h:Single;Color:Integer;var mas:array of TD3DLVertex);
var i:Integer;
begin
i:=0;

//====side 1
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;


//====side 2
inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;


//====side 3
inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;


//====side 4
inc(i);
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;


//====side 5
inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y+h;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;


//====side 6
inc(i);
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z+d;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=1;

inc(i);
mas[i].x:= x;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=0;
mas[i].tv:=0;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z+z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=1;

inc(i);
mas[i].x:= x+w;
mas[i].y:= y;
mas[i].z:= z;
mas[i].Color:=Color;
mas[i].tu:=1;
mas[i].tv:=0;



end;















end.
