unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DirectX,d3dmatch,DXTexMat,jpeg, StdCtrls,Gdebug;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    Button1: TButton;
    ListBox2: TListBox;
    Label2: TLabel;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListBox2DblClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    procedure ExceptionHandler( Sender : TObject ; E : Exception ) ;

  public
    { Public declarations }
  end;




  PDevInfo = ^TDevInfo;
  TDevInfo = record
     guid       : TGuid;
     isHardvare :Boolean;
     isZSupport :Boolean;
     isWSupport :Boolean;
    end;

  procedure RenderIni;
  procedure RenderFrame;
  procedure FlipSurf;


var
  Form1: TForm1;
  FirstTime: Boolean;


  GoFrameFlip:Boolean;

  fDeviceFound: Boolean;
  NumDev      : Integer;


  x_width, x_height : Integer;


  {  Ddraw}
  ddi:IDirectDraw4;

  //  
  // err in DXTexMat

  {  D3D}
  d3di:IDirect3D3;

  {  DirectDevice}
  d3ddevice : IDirect3DDevice3;

  {  ,  ,    }
  d3dviewport : IDirect3DViewport3;

  viewreg     : TD3DVIEWPORT2;




  {,    }
  ddsMain   : IDirectDrawSurface4; // main surface
  ddsBack   : IDirectDrawSurface4; // back surfase
  ddZBuffer : IDirectDrawSurface4; // ZBufer




  //     FPS variable

  fps   : integer;
  fps_o : integer;
  tims_o: TSystemTime; 









  Textures : TDXTexture;




   { }

   //ddsd : TDDSURFACEDESC2  in DXTexMat;
   ddsc : TDDSCAPS2;

   dd3dS : TD3DDEVICEDESC;
   dd3dH : TD3DDEVICEDESC;


   matrW : TD3DMATRIX;
   matrV : TD3DMATRIX;
   matrP : TD3DMATRIX;


  

  rr: TD3DRect;
  vv: array[0..4] of TD3DTLVertex;



implementation

{$R *.DFM}


procedure TForm1.ExceptionHandler( Sender : TObject ; E : Exception ) ;
begin

if ( ddi <> nil ) then ddi.FlipToGDISurface ;
MessageDlg(  'Error - > '+E.Message, mtError, [ mbOK ], 0 ) ;

end ;


//  
procedure ReleaseDXAll;
begin
  dbg_logmes('flip to gdi',0);


     Textures.Free;

     if (ddi <> nil) then
        begin
          dbg_logmes('flip real',0);
          ddi.FlipToGDISurface ;
        end;

     if (ddi <> nil) then
        begin
           dbg_logmes('rest real',0);
           ddi.RestoreDisplayMode;
        end;



     dbg_logmes('beg release',0);
     if (d3dviewport <> nil) then
        begin
          dbg_logmes('rel real',0);
          d3dviewport.Release;
          d3dviewport:=nil;
        end;



     dbg_logmes('main release',0);
     if (ddsMain <> nil) then
        begin
          dbg_logmes('rel real',0);
          ddsMain.Release;
          ddsMain:=nil;
        end;




     if (ddi <> nil) then
        begin
           dbg_logmes('ddi rel real',0);
           ddi.Release;
        end;

     dbg_logmes('fini release',Integer(ddi));
end;

//  
procedure RestoreSurfaces;
begin

    if (ddZBuffer <> nil) then
       begin
           ddZBuffer._Restore;
       end;

    if (ddsMain <> nil) then
       begin
           ddsMain._Restore;
       end;

    if (ddsBack <> nil) then
       begin
           ddsBack._Restore;
       end;


end;



//     
function EnumModeCallback(p1:PDDSURFACEDESC2 ; p2:Pointer):Integer;stdcall;
begin

Form1.ListBox1.Items.Add(IntToStr(p1.dwWidth)+'X'+IntToStr(p1.dwHeight)+'x'+IntToStr(p1.ddpfPixelFormat.dwRGBBitCount)+' :'+IntToStr(p1.dwRefreshRate)+'Hz');

Result:=DDENUMRET_OK;
end;



//     
function EnumDeviceCallback(  lpGUID: PGUID;
                              lpszDeviceDesc: PAnsiChar;
                              lpszDeviceName: PAnsiChar;
                              lpd3dHWDeviceDesc: PD3DDEVICEDESC;
                              lpd3dSWDeviceDesc: PD3DDEVICEDESC;
                              lpUserArg: Pointer
                           ):HResult;stdcall;
var
    DevInfo: PDevInfo;

begin


fDeviceFound:=True;

//         ListBox2
new(DevInfo);
CopyMemory(@DevInfo.guid,lpGuid,SizeOf(TGuid));

DevInfo.isHardvare:=False;
DevInfo.isZSupport:=False;
DevInfo.isWSupport:=False;


if (lpd3dHWDeviceDesc.dwFlags and D3DDD_COLORMODEL) = D3DDD_COLORMODEL then
  begin

          DevInfo.isHardvare:=True;
          NumDev:= Form1.ListBox2.Items.Count;

          if (lpd3dHWDeviceDesc.dwDeviceZBufferBitDepth and DDBD_16) <> DDBD_16 then
             begin
               DevInfo.isZSupport:=True;
             end;
          if (lpd3dHWDeviceDesc.dpcTriCaps.dwRasterCaps and D3DPRASTERCAPS_WBUFFER) = D3DPRASTERCAPS_WBUFFER then
             begin
               DevInfo.isWSupport:=True;
             end;


  end else
  begin
          if (lpd3dSWDeviceDesc.dwDeviceZBufferBitDepth and DDBD_16) <> DDBD_16 then
             begin
               DevInfo.isZSupport:=True;
             end;
          if (lpd3dSWDeviceDesc.dpcTriCaps.dwRasterCaps and D3DPRASTERCAPS_WBUFFER) = D3DPRASTERCAPS_WBUFFER then
             begin
               DevInfo.isWSupport:=True;
             end;

  end;




Form1.ListBox2.Items.AddObject(String(lpszDeviceName)+' ->'+String(lpszDeviceDesc),TObject(DevInfo));

Result:=D3DENUMRET_OK;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  FirstTime:=True;
  Application.OnException := ExceptionHandler;
  dbg_Init('C:\TEMP\dx1.dbg',LOG_OVERWRITE);


end;

procedure TForm1.FormActivate(Sender: TObject);
begin



if FirstTime then
  begin
     FirstTime:=False;
     x_width:=640;
     x_height:=480;

     ddi:=nil;
     ddsMain:=nil;
     ddsBack:=nil;
     ddZBuffer:=nil;
     d3di:=nil;
     d3ddevice := nil;
     d3dviewport:=nil;


     rr.x1:= 0;
     rr.y1:= 0;
     rr.x2:= x_width;
     rr.y2:= x_height;



     dbg_logmes('create dx',0);
     ListBox1.Items.Add(' '' DirectDrawX 1..... ');

     //  DirectDraw
     err := DirectDrawCreate(nil,IDirectDraw(ddi), nil );
     if err<>dd_ok then
        begin
          dbg_logerr(DXErrorString(err),0);
          ListBox1.Items.Add('  DirectX');

          exit;
        end;

     ListBox1.Items.Add(' -> ' + IntToHex(Integer(ddi),4));


     ListBox1.Items.Add(' '' DirectDrawX 6.0..... ');

     //   DirectDraw4
     err := ddi.QueryInterface(IID_IDirectDraw4,ddi);
     if err<>dd_ok then
        begin
          dbg_logerr(DXErrorString(err),0);
          ListBox1.Items.Add('  DirectX 6.0');

          exit;
        end;





     dbg_logmes('cooperative',0);
     ListBox1.Items.Add('  ..... ');
//     DDSCL_FPUSETUP
     err := ddi.SetCooperativeLevel(Form1.Handle,DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN );
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);

           ListBox1.Items.Add('');
           ListBox1.Items.Add('   ');
           exit;
         end;
     ListBox1.Items.Add('');


     ListBox1.Items.Add('    ----');

     err := ddi.EnumDisplayModes(0,nil,nil,@EnumModeCallback);
     if err<>dd_ok then
         begin
           ListBox1.Items.Add('');
           exit;
         end;
     ListBox1.Items.Add('------------------------------------');




     dbg_logmes('setMode',0);
     ListBox1.Items.Add('   640x480x16 ..... ');
     err := ddi.SetDisplayMode( x_width, x_height, 16,0,0 );
     if err<>dd_ok then
         begin
           ListBox1.Items.Add('');
           exit;
         end;

     ListBox1.Items.Add('');
	// 16    


     dbg_logmes('Surface create',0);
     ListBox1.Items.Add(' ..... ');
     ZeroMemory( @ddsd, SizeOf( ddsd ));
     With ddsd do begin
          dwSize := SizeOf( ddsd );
          dwFlags :=
            DDSD_CAPS or
            DDSD_BACKBUFFERCOUNT;
          ddsCaps.dwCaps :=
            DDSCAPS_3DDEVICE or
            DDSCAPS_FLIP or
            DDSCAPS_COMPLEX or
            DDSCAPS_PRIMARYSURFACE or
            DDSCAPS_VIDEOMEMORY;
          dwBackBufferCount := 1;
        end;




     err := ddi.CreateSurface( ddsd, ddsMain, nil );
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('   ');
           exit;
         end;
     ListBox1.Items.Add(' -> ' + IntToHex(Integer(ddsMain),4));

     ListBox1.Items.Add(' ...');
     ddsc.dwCaps := DDSCAPS_BACKBUFFER;



     err := ddsMain.GetAttachedSurface( ddsc, ddsBack );
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('     ');
           exit;
         end;
     ListBox1.Items.Add(' -> ' + IntToHex(Integer(ddsBack),4));



     dbg_logmes('QueryInterface',0);
     ListBox1.Items.Add('   D3D3..... ');
     ListBox1.Items.Add('  DirectX 6.0...');

     err := ddi.QueryInterface( IID_IDirect3D3, d3di );
     if err<>dd_ok then
        begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('');
           exit;
        end;
     ListBox1.Items.Add(' -> ' + IntToHex(Integer(d3di),4));


     Textures:= TDXTexture.Create(ddi);


     ListBox1.Items.Add(' ...');
     fDeviceFound:=False;
     NumDev:=0;


     err := d3di.EnumDevices(@EnumDeviceCallback, nil);
     if err<>dd_ok then
        begin
           ListBox1.Items.Add('');
           exit;
        end;
     if not fDeviceFound then
        begin
           ListBox1.Items.Add(' ');
           exit;
        end;


     ListBox2.ItemIndex:=NumDev;


     ListBox1.Items.Add('');

     Button2.Enabled:=True;

  end;



end;


// FPS
procedure fps_show(s_:string);
var tims:TSystemTime;
    dc:HDc;
    s:string;

begin


     datetimetosystemtime(Now,tims);

     if tims.wSecond<>tims_o.wSecond then
      begin
          tims_o:=tims;
          fps_o:=fps;
          fps:=0;
      end;
        inc(fps);
        ddsBack.getdc(dc);
     try
        settextcolor(dc,clWhite);
        setbkmode(dc,transparent);
        s:=s_+inttostr(fps_o);
        textout(dc,1,1,pchar(s),length(s));
     finally
        ddsBack.ReleaseDC(dc);
     end;

end;




procedure TForm1.Button1Click(Sender: TObject);
begin
GoFrameFlip:=True;

// 
RenderIni;

while GoFrameFlip do
  begin
    RenderFrame;
    fps_show('FPS= ');

    FlipSurf;

    //      
    Application.ProcessMessages;
  end;


end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var i: Integer;
begin
 dbg_logmes('End beg',0);



  Form1.Enabled:=False;


  dbg_logmes('beg dispose',0);

  i:=0;
  while i<ListBox2.Items.Count do
     begin
       Dispose(Pointer(ListBox2.Items.Objects[i]));
       inc(i);
     end;
  ListBox2.Clear;


 ReleaseDXAll;

 Application.OnException := nil;



 dbg_Done;
end;








//     D3D
procedure ReleasePrevios;
begin
Form1.ListBox1.Items.Add('<=-----------------------=>');

  if (ddZBuffer <> nil) then
     begin

        if ((d3dviewport <> nil) and (d3ddevice<>nil)) then
          begin
             Form1.ListBox1.Items.Add('ViewPort ');
             d3ddevice.DeleteViewport(d3dviewport);
             d3dviewport.Release;
             d3dviewport:=nil;

             Form1.ListBox1.Items.Add(' ');
             d3ddevice.Release;
             d3ddevice:=nil;

          end;




       ddsBack.DeleteAttachedSurface(0,ddZBuffer);
       ddZBuffer.Release;
       ddZBuffer := nil;
       Form1.ListBox1.Items.Add('Z  ');
     end;

end;



procedure TForm1.ListBox2DblClick(Sender: TObject);
var
    dwZBufferMemType: DWORD;
begin

  Button1.Enabled:=False;
  ReleasePrevios;



  if PDevInfo(ListBox2.Items.Objects[ListBox2.ItemIndex]).isZSupport then
      begin
       ListBox1.Items.Add('  Z Bufer 16 Bit');
       exit;
      end;

  if PDevInfo(ListBox2.Items.Objects[ListBox2.ItemIndex]).isWSupport then
    begin
      ListBox1.Items.Add('  W Bufer !');
    end;

  if PDevInfo(ListBox2.Items.Objects[ListBox2.ItemIndex]).isHardvare then
    begin
     //Hardvare detected!

     dwZBufferMemType := DDSCAPS_VIDEOMEMORY;
     ListBox1.Items.Add(' 3D');
   end
   else
   begin
     // soft

     dwZBufferMemType := DDSCAPS_SYSTEMMEMORY;
     ListBox1.Items.Add(' 3D');
   end;

   // Z 
   ZeroMemory( @ddsd, SizeOf( ddsd ));
   ddsd.dwSize            := sizeof(ddsd);
   ddsd.dwFlags           := DDSD_CAPS or DDSD_PIXELFORMAT or DDSD_WIDTH or DDSD_HEIGHT;
   ddsd.dwWidth           := x_width;
   ddsd.dwHeight          := x_height;
   ddsd.ddsCaps.dwCaps    := DDSCAPS_ZBUFFER or dwZBufferMemType;

   ddsd.ddpfPixelFormat.dwSize:=SizeOf(TDDPixelFormat);
   ddsd.ddpfPixelFormat.dwFlags:=DDPF_ZBUFFER;
   ddsd.ddpfPixelFormat.dwFourCC:=0;
   ddsd.ddpfPixelFormat.dwZBufferBitDepth:= 16;
   ddsd.ddpfPixelFormat.dwZBitMask:=$FFFFFFFF;

   ListBox1.Items.Add(' Z ');
   err := ddi.CreateSurface( ddsd, ddZBuffer, nil );
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('  Z ');
           exit;
         end;
   ListBox1.Items.Add(' -> ' + IntToHex(Integer(ddZBuffer),4));


   ListBox1.Items.Add(' Z ');
   err := ddsBack.AddAttachedSurface(ddZBuffer);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('');
           exit;
         end;
     ListBox1.Items.Add('');







  ListBox1.Items.Add(' ...');

  err:= d3di.CreateDevice(PDevInfo(ListBox2.Items.Objects[ListBox2.ItemIndex]).guid,Pointer(ddsBack),d3ddevice,nil);
  if err<>dd_ok then
        begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add('');
           exit;
        end;
  ListBox1.Items.Add(' -> ' + IntToHex(Integer(d3ddevice),4));




     ListBox1.Items.Add('   ViewPort.....');
     ZeroMemory( @viewreg, SizeOf( viewreg ));
     viewreg.dwSize := SizeOf( viewreg );
     viewreg.dwWidth := x_width;
     viewreg.dwHeight := x_height;
     viewreg.dvClipX := -50;
     viewreg.dvClipWidth := 100;
     viewreg.dvClipY := 50;
     viewreg.dvClipHeight := 100;
     viewreg.dvMinZ := -50;
     viewreg.dvMaxZ :=  50;



     err := d3di.CreateViewport( d3dviewport, nil );
      if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add(' VP1');
           exit;
         end;



     err := d3ddevice.AddViewport( d3dviewport );
       if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add(' VP2');
           exit;
         end;
     err := d3dviewport.SetViewport2( viewreg );
       if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add(' VP3');
           exit;
         end;

     err :=d3ddevice.SetCurrentViewport( d3dviewport );
      if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           ListBox1.Items.Add(' VP4');
           exit;
         end;

      ListBox1.Items.Add(' -> ' + IntToHex(Integer(d3dviewport),4));

      Button1.Enabled:=True;

end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
 dbg_logMes('Key',Byte(Key));


 if Byte(Key) = 27 then
        begin
            GoFrameFlip:=False;
            Close;
         end;
end;














// 
procedure RenderIni;
var
        pdinf: PDevInfo;
        t1,t2,t3,t4,t5   : Integer;
begin
{
dbg_logmes('matrW',0);
matrW:= IdentityMatrix;

dbg_logmes('matrV',0);
matrV:= ViewMatrix(setd3dvector(-5,0,10),setd3dvector(1,0,0),setd3dvector(0,1,0),0);

dbg_logmes('matrP',0);
matrP:= ProjectionMatrix(1,50,pi * 0.1,pi * 0.1);


dbg_logmes('Begin Set Transform',0);
err:=d3ddevice.SetTransform(D3DTRANSFORMSTATE_WORLD, matrW);
if err<>dd_ok then
        begin
           dbg_logerr(DXErrorString(err),err);
           exit;
        end;
err:=d3ddevice.SetTransform(D3DTRANSFORMSTATE_VIEW, matrV);
if err<>dd_ok then
        begin
           dbg_logerr(DXErrorString(err),err);
           exit;
        end;
err:=d3ddevice.SetTransform(D3DTRANSFORMSTATE_PROJECTION, matrP);
if err<>dd_ok then
        begin
           dbg_logerr(DXErrorString(err),err);
           exit;
        end;

}


    Randomize;





//  
{
     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_CULLMODE,Integer(D3DCULL_CW));
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;
}


pdinf:=PDevInfo(Form1.ListBox2.Items.Objects[Form1.ListBox2.ItemIndex]);

if  pdinf.isHardvare then
                       begin
                          t1:=Integer(D3DANTIALIAS_SORTINDEPENDENT);
                          t2:=Integer(D3DSHADE_GOURAUD);
                          t3:=$FFFFFFFF;
                          t4:=$FFFFFFFF;
                          t5:=Integer(D3DFILTER_LINEAR);

                       end
                     else
                       begin
                          t1:=Integer(D3DANTIALIAS_NONE);
                          t2:=Integer(D3DSHADE_FLAT);
                          t3:=0;
                          t4:=0;
                          t5:=Integer(D3DFILTER_NEAREST);


                       end;


     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_ANTIALIAS,t1);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;


     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_SHADEMODE,t2);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;



     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_DITHERENABLE,t3);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;


     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_EDGEANTIALIAS,t4);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;


     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_TEXTUREMAG,t5);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;

     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_TEXTUREMIN,t5);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;



     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_TEXTUREPERSPECTIVE,$FFFFFFFF);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;



     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_FILLMODE,Integer(D3DFILL_SOLID));
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;



     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_ZENABLE,Integer(D3DZB_TRUE));
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;




     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_ZWRITEENABLE,$FFFFFFFF);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;






     err:= d3ddevice.SetRenderState(D3DRENDERSTATE_ZFUNC,Integer(D3DCMP_LESS));
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;





// 
     if not Textures.CreateTexture(256,256) then
          begin
           dbg_logerr('  1',0);
           exit;
          end;

     if not Textures.CreateTexture(256,256) then
          begin
           dbg_logerr('  2',0);
           exit;
          end;

//  
     Textures.LoadTexture(0,'tex1.jpg');
     Textures.LoadTexture(1,'tex2.jpg');







end;



procedure RenderFrame;
var
       i:Integer;
begin


   d3dviewport.Clear(1, rr, D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER);



   err:= d3ddevice.BeginScene;
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;

         end;

i:= 100;


while (i > 0) do
 begin

   // 
   CreatePlosDir(random(500),180+random(300),0.3,20+Random(100),20+Random(100),1,RGB_MAKE(Random($FF),Random($FF),Random($FF)),vv);


   //   
   err:= d3ddevice.SetTexture(0,Textures.GetTex(Random(2)));
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;

   //  
   err:= d3ddevice.DrawPrimitive(D3DPT_TRIANGLESTRIP,D3DFVF_TLVERTEX,vv[0],4,D3DDP_DONOTUPDATEEXTENTS);
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;


   dec(i);
 end;




   err:= d3ddevice.EndScene;
     if err<>dd_ok then
         begin
           dbg_logerr(DXErrorString(err),0);
           exit;
         end;


end;


//  
procedure FlipSurf;
begin
 While ( True ) do begin
   err := ddsMain.Flip( nil, 0 );
   If ( err = DD_OK ) then break;
   If ( err = DDERR_SURFACELOST ) then
       begin
         err := ddsMain._Restore;
         If ( err <> DD_OK ) then break;
       end;

    If ( err <> DDERR_WASSTILLDRAWING ) then break;
 end;
end;



procedure TForm1.Button2Click(Sender: TObject);
begin
 ListBox2DblClick(Sender);
end;

end.
