unit d3dmatch;

interface
uses directx;


function zeroMatrix:TD3DMATRIX;
function IdentityMatrix:TD3DMATRIX;
function matrixmult(a,b:TD3DMatrix):TD3DMatrix;
function translate(dx,dy,dz:single):TD3DMatrix;
function rotatex(r:single):TD3DMatrix;
function rotatey(r:single):TD3DMatrix;
function rotatez(r:single):TD3DMatrix;
function scale(s:single):TD3DMatrix;
function squaremagnitude(v:TD3DVector):TD3DValue;
function magnitude(v1:TD3DVector):TD3DValue;

function normalize(v1,v2:TD3DVector):TD3DVector;
function normalize_(v:TD3DVector):TD3DVector;
function crossproduct(v1,v2:TD3DVector):TD3DVector;
function dotproduct(v1,v2:TD3DVector):TD3DValue;
function viewmatrix(from,at,world_up:TD3DVector;roll:single):TD3DMatrix;

function projectionmatrix(np,fp,fovh,fovv:single):TD3DMatrix;
function setd3dSvertex(x,y,z,u,v:single):TD3dSVertex;
function setd3dtlvertex(x,y,z:single;c1,c2:integer;u,v:single;r:Single):TD3DtlVertex;
function setd3dlvertex(x,y,z:single;c1,c2:integer;u,v:single):TD3DlVertex;
function setd3dvector(x,y,z:single):TD3DVector;
function setd3dnvertex(x,y,z,nx,ny,nz,u,v:single):TD3dVertex;





implementation

function zeroMatrix:TD3DMATRIX;assembler;
asm
  push EBX
  xor EBX,EBX
  mov result._11,EBX
  mov result._12,EBX
  mov result._13,EBX
  mov result._14,EBX
  mov result._21,EBX
  mov result._22,EBX
  mov result._23,EBX
  mov result._24,EBX
  mov result._31,EBX
  mov result._32,EBX
  mov result._33,EBX
  mov result._34,EBX
  mov result._41,EBX
  mov result._42,EBX
  mov result._43,EBX
  mov result._44,EBX
  pop EBX
end;


function IdentityMatrix:TD3DMATRIX;
begin
result:=zeromatrix;
result._11:=1;
result._22:=1;
result._33:=1;
result._44:=1;
end;




function matrixmult(a,b:TD3DMatrix):TD3DMatrix;
var
      i,j,k :integer;
begin
     result:=zeromatrix;
     for i:=0 to 3 do
         for j:=0 to 3 do
             for k:=0 to 3 do
                 result.m[i,j]:=Result.m[i,j]+a.m[k,j]*b.m[i,k];
end;


function translate(dx,dy,dz:single):TD3DMatrix;
begin
     result:=identitymatrix;
     result._41:=dx;
     result._42:=dy;
     result._43:=dz;
end;

function rotatex(r:single):TD3DMatrix;
var c,s:single;
begin
      c:=cos(r);
      s:=sin(r);

      result:= IdentityMatrix;
      result._22:= c;
      result._33:= c;
      result._23:= -s;
      result._32:= s;
end;

function rotatey(r:single):TD3DMatrix;
var c,s:single;
begin
     c:=cos(r);
     s:=sin(r);

     result:= IdentityMatrix;
     result._11:= c;
     result._33:= c;
     result._13:= s;
     result._31:= -s;
end;

function rotatez(r:single):TD3DMatrix;
var c,s:single;
begin
     c:=cos(r);
     s:=sin(r);

     result:= IdentityMatrix;
     result._11:= c;
     result._22:= c;
     result._12:= s;
     result._21:= -s;
end;


function scale(s:single):TD3DMatrix;
begin
     result:= IdentityMatrix;
     result._11:= s;
     result._22:= s;
     result._33:= s;
end;

function squaremagnitude(v:TD3DVector):TD3DValue;
begin
     result:=v.x*v.x + v.y*v.y + v.z*v.z;
end;

function magnitude(v1:TD3DVector):TD3DValue;
begin
     result:=sqrt(squaremagnitude(v1));
end;

function normalize(v1,v2:TD3DVector):TD3DVector;
var m:TD3DValue;
begin
     v1.x:=v1.x-v2.x;
     v1.y:=v1.y-v2.y;
     v1.z:=v1.z-v2.z;
     m:=magnitude(v1);
     result.x:=v1.x/m;
     result.y:=v1.y/m;
     result.z:=v1.z/m;
end;

function normalize_(v:TD3DVector):TD3DVector;
var m:TD3DValue;
begin
     m:=magnitude(v);
     result.x:=v.x/m;
     result.y:=v.y/m;
     result.z:=v.z/m;
end;

function crossproduct(v1,v2:TD3DVector):TD3DVector;
begin
     result.x:= v1.y * v2.z - v1.z * v2.y;
     result.y:= v1.z * v2.x - v1.x * v2.z;
     result.z:= v1.x * v2.y - v1.y * v2.x;
end;

function dotproduct(v1,v2:TD3dVector):TD3dValue;
begin
     result:=v1.x*v2.x + v1.y * v2.y + v1.z*v2.z;
end;

//   
// from -  
// at -   
// wotld_up -  
// roll -   Z - 
function viewmatrix(from,at,world_up:TD3dVector;roll:single):TD3DMatrix;
var  u,r,vd:TD3DVector;
begin
     Result:=identitymatrix;
     vd:=normalize(at,from);

     r:=crossproduct(world_up,vd);
     u:=crossproduct(vd,r);
     r:=normalize_(r);
     Result._11:= r.x;
     Result._21:= r.y;
     Result._31:= r.z;
     Result._12:= u.x;
     Result._22:= u.y;
     Result._32:= u.z;
     Result._13:= vd.x;
     Result._23:= vd.y;
     Result._33:= vd.z;
     Result._41:= -DotProduct(r, from);
     Result._42:= -DotProduct(u, from);
     Result._43:= -DotProduct(vd, from);
     if roll<>0 then
        Result:=matrixmult(rotatez(-roll),Result);
end;


//  
// np -   
// fp -   
// fovh -     ()
// fovv -     ()
function projectionmatrix(np,fp,fovh,fovv:single):TD3DMatrix;
var h,w,Q:single;
begin
     w:=cos(fovh/2);
     h:=cos(fovv/2);
     Q:=fp/(fp-np);

     result:=zeromatrix;
     result._11:= w;
     result._22:= h;
     result._33:= Q;
     result._43:= -Q*np;
     result._34:= 1;

end;

function setd3dtlvertex(x,y,z:single;c1,c2:integer;u,v:single;r:Single):TD3dtlVertex;
begin
     result.sx:=x;
     result.sy:=y;
     result.sz:=z;
     result.color:=c1;
     result.specular:=c2;
     result.TU:=u;
     result.TV:=v;
     result.rhw:=r;
end;



function setd3dlvertex(x,y,z:single;c1,c2:integer;u,v:single):TD3dlVertex;
begin
     result.dvx:=x;
     result.dvy:=y;
     result.dvz:=z;
     result.color:=c1;
     result.specular:=c2;
     result.TU:=u;
     result.TV:=v;
end;

function setd3dSvertex(x,y,z,u,v:single):TD3dSVertex;
begin
     result.x:=x;
     result.y:=y;
     result.z:=z;
     result.TU:=u;
     result.TV:=v;
end;

function setd3dvector(x,y,z:single):TD3dVector;
begin
     result.x:=x;
     result.y:=y;
     result.z:=z;
end;


function setd3dnvertex(x,y,z,nx,ny,nz,u,v:single):TD3dVertex;
begin
     result.x:=x;
     result.y:=y;
     result.z:=z;
     result.nx:=nx;
     result.ny:=ny;
     result.nz:=nz;
     result.tu:=u;
     result.tv:=v;
end;



procedure DisableFPUExceptions;
var
  FPUControlWord: WORD;
asm
  FSTCW   FPUControlWord;
  AND     FPUControlWord, $FFFFFCFF ; // single mode
  OR      FPUControlWord, $3f       ; // disable all exceptions
  AND     FPUControlWord, $FFFFF3FF ; // round to nearest mode
  FLDCW   FPUControlWord;
end;

begin
disablefpuexceptions;

end.

