//**********************************************************
//        
// DirectX Graphics -  
// :   aka Anti
// 
//  ,     ,  
//     ,     
// La Vision (http://www.la-vision.net)
// 
// : <support@la-vision.net>
//
//       
//    
//**********************************************************


#include <d3dx8.h>
#include <mmsystem.h>

LPDIRECT3D8 g_pD3D = NULL; //  Direct3D
LPDIRECT3DDEVICE8 g_pd3dDevice = NULL; // 
LPDIRECT3DVERTEXBUFFER8 g_pVB = NULL; //  
LPDIRECT3DTEXTURE8      g_pTexture   = NULL; //

//,     (aka FVF)
struct CUSTOMVERTEX
{
	D3DXVECTOR3 position; // 3D- 
    D3DCOLOR    color;    // 
    FLOAT       tu, tv;   //  
};

//   FVF
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)

VOID Cleanup();
HRESULT InitD3D( HWND hWnd );
HRESULT InitGeometry();
VOID SetupMatrices();
VOID Render();




LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_DESTROY:
			PostQuitMessage( 0 );
			return 0;
	}

	return DefWindowProc( hWnd, msg, wParam, lParam );
}

 

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
	//  
	WNDCLASSEX wc = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 0L,
			GetModuleHandle(NULL), NULL, NULL, NULL, NULL,
			"D3D Tutorial", NULL };
	RegisterClassEx( &wc ); 

	//  
	HWND hWnd = CreateWindow( "D3D Tutorial", "DirectX Graphics 5 - ",
			WS_OVERLAPPEDWINDOW, 100, 100, 300, 300,
			GetDesktopWindow(), NULL, wc.hInstance, NULL );

	//  Direct3D
	if( SUCCEEDED( InitD3D( hWnd ) ) )
	{
		//  
		if( SUCCEEDED( InitGeometry() ) )
		{
			//  
			ShowWindow( hWnd, SW_SHOWDEFAULT );
			UpdateWindow( hWnd );

			//     
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message!=WM_QUIT )
			{
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
				{
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}
					else
				Render();
			}
		}
	}

	//    
	Cleanup();
	UnregisterClass( "D3D Tutorial", wc.hInstance );
	return 0;
}



HRESULT InitD3D( HWND hWnd )
{
	//   D3D,      
	if( NULL == ( g_pD3D = Direct3DCreate8( D3D_SDK_VERSION ) ) )
	return E_FAIL;

	//    
	D3DDISPLAYMODE d3ddm;
	if( FAILED( g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
	return E_FAIL;

	D3DPRESENT_PARAMETERS d3dpp; 
	ZeroMemory( &d3dpp, sizeof(d3dpp) );
	d3dpp.Windowed = TRUE;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

	if( FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,
			&d3dpp, &g_pd3dDevice ) ) )
	{
	return E_FAIL;
	}

	//  culling ,         
	g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    //   D3D
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );

	//  Z-
	g_pd3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

	//   ,   - 
	return S_OK;
}

 

VOID Cleanup()
{
	if( g_pTexture != NULL )
			g_pTexture->Release();

	if( g_pVB != NULL ) 
			g_pVB->Release();

	if( g_pd3dDevice != NULL) 
			g_pd3dDevice->Release();

	if( g_pD3D != NULL)
			g_pD3D->Release();
}



HRESULT InitGeometry()
{
    //   D3DX  ,      
    if( FAILED( D3DXCreateTextureFromFile( g_pd3dDevice, "texture.bmp",
                                           &g_pTexture ) ) )
        return E_FAIL;

	//   
	if( FAILED( g_pd3dDevice->CreateVertexBuffer( 50*2*sizeof(CUSTOMVERTEX),
			0, D3DFVF_CUSTOMVERTEX,
			D3DPOOL_DEFAULT, &g_pVB ) ) )
	{
		return E_FAIL;
	}

    //   .    tu  tv,
    //      0.0  0.1
    CUSTOMVERTEX* pVertices;
    if( FAILED( g_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 ) ) )
        return E_FAIL;

    for( DWORD i=0; i<50; i++ )
    {
        FLOAT theta = (2*D3DX_PI*i)/(50-1);

        pVertices[2*i+0].position = D3DXVECTOR3( sinf(theta),-1.0f, cosf(theta) );
        pVertices[2*i+0].color    = 0xffffffff;
        pVertices[2*i+0].tu       = ((FLOAT)i)/(50-1);
        pVertices[2*i+0].tv       = 1.0f;

        pVertices[2*i+1].position = D3DXVECTOR3( sinf(theta), 1.0f, cosf(theta) );
        pVertices[2*i+1].color    = 0xff808080;
        pVertices[2*i+1].tu       = ((FLOAT)i)/(50-1);
        pVertices[2*i+1].tv       = 0.0f;
    }
    g_pVB->Unlock();

	return S_OK;
}



VOID SetupMatrices()
{
	//   
	D3DXMATRIX matWorld;
	D3DXMatrixIdentity( &matWorld );
	D3DXMatrixRotationX( &matWorld, timeGetTime()/500.0f );
	g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

	//   
	D3DXMATRIX matView;
	D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 3.0f,-5.0f ),
								  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ),
								  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
	g_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

	//   
	D3DXMATRIX matProj;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.0f, 1.0f, 100.0f );
	g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}


VOID Render()
{
    //     z-   
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
                         D3DCOLOR_XRGB(0,0,255), 1.0f, 0 );

    //   
    g_pd3dDevice->BeginScene();

    //   ,   
    SetupMatrices();

	//     
	g_pd3dDevice->SetTexture( 0, g_pTexture );

    //    
    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

    //    
    g_pd3dDevice->SetStreamSource( 0, g_pVB, sizeof(CUSTOMVERTEX) );
    g_pd3dDevice->SetVertexShader( D3DFVF_CUSTOMVERTEX );
    g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2*50-2 );

    // 
    g_pd3dDevice->EndScene();

    //      
    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}




