VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "DirectX Graphics:  5 - "
   ClientHeight    =   4500
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5730
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   300
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   382
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'//**********************************************************
'//        
'// DirectX Graphics -  
'// :   aka Anti
'//
'//  ,     , 
'//     ,    
'// La Vision (http://www.la-vision.net)
'//
'// : <support@la-vision.net>
'//
'//       
'//    
'//**********************************************************

Option Explicit

'  DirectX
Dim dx As New DirectX8 ' DirectX8
Dim d3d As Direct3D8 ' Direct3D
Dim d3dx As New D3DX8 ' Direct3DX
Dim d3dDevice As Direct3DDevice8 '  
Dim pVB As Direct3DVertexBuffer8 '  
Dim pTexture As Direct3DTexture8 '

'  ?
Dim Running As Boolean

',     (aka FVF)
Private Type CUSTOMVERTEX
    Position As D3DVECTOR '3D- 
    color As Long '
    tu As Single ' 
    tv As Single
End Type

'   FVF
Private Const D3DFVF_CUSTOMVERTEX = (D3DFVF_XYZ Or D3DFVF_DIFFUSE Or D3DFVF_TEX1)

Private Const pi = 3.141592


'    -  
Private Sub Form_KeyPress(KeyAscii As Integer)
    Running = False
End Sub

'      Direct3D
Private Sub Form_Load()
    Me.Show ' 
    InitD3D ' D3D
    InitGeometry '  
    Running = True
    Do While Running '  
        Render
    Loop
    End
End Sub

' Direct3D
Private Sub InitD3D()
    '   
    Dim DispMode As D3DDISPLAYMODE
    Dim d3dpp As D3DPRESENT_PARAMETERS
    
    '  Direct3D
    Set d3d = dx.Direct3DCreate
    '   
    Call d3d.GetAdapterDisplayMode(D3DADAPTER_DEFAULT, DispMode)
    
    '    
    d3dpp.Windowed = True
    d3dpp.SwapEffect = D3DSWAPEFFECT_COPY_VSYNC
    d3dpp.BackBufferFormat = DispMode.Format
    d3dpp.BackBufferCount = 1
    d3dpp.EnableAutoDepthStencil = True
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16
    
    '  
    Set d3dDevice = d3d.CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, Me.hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, d3dpp)
    
    ' culling ,         
    Call d3dDevice.SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE)
    
    ' Z-
    Call d3dDevice.SetRenderState(D3DRS_ZENABLE, 1)
    
    '  D3D      
    d3dDevice.SetRenderState D3DRS_LIGHTING, 0
    
End Sub

Private Sub InitGeometry()
    Dim Vertices(100) As CUSTOMVERTEX
    Dim I As Integer, Theta As Single
    
    '  D3DX  ,      
    On Error Resume Next
    Set pTexture = d3dx.CreateTextureFromFile(d3dDevice, App.Path + "\texture.bmp")
    If pTexture Is Nothing Then
        MsgBox "  "
        End
    End If
    
    
    '  .    tu  tv,
    '     0.0  0.1
    For I = 0 To 49
        Theta = (2 * pi * I) / (50 - 1)
        
        Vertices(2 * I + 0).Position = vec3(Sin(Theta), -1, Cos(Theta))
        Vertices(2 * I + 0).color = &HFFFFFFFF  '
        Vertices(2 * I + 0).tu = I / (50 - 1)
        Vertices(2 * I + 0).tv = 1
        
        Vertices(2 * I + 1).Position = vec3(Sin(Theta), 1, Cos(Theta))
        Vertices(2 * I + 1).color = &HFF808080  '
        Vertices(2 * I + 1).tu = I / (50 - 1)
        Vertices(2 * I + 1).tv = 0
    Next I

    
    '      
    Set pVB = d3dDevice.CreateVertexBuffer(50 * 2 * Len(Vertices(0)), 0, D3DFVF_CUSTOMVERTEX, D3DPOOL_DEFAULT)
    '     
    Call D3DVertexBuffer8SetData(pVB, 0, Len(Vertices(0)) * 100, 0, Vertices(0))
    
End Sub

Private Sub SetupMatrices()
    Dim MatWorld As D3DMATRIX
    Dim MatView As D3DMATRIX
    Dim MatProjection As D3DMATRIX
    
    '       
    Call D3DXMatrixRotationAxis(MatWorld, vec3(1, 1, 1), Timer / 4)
    Call d3dDevice.SetTransform(D3DTS_WORLD, MatWorld)
    
    '  
    Call D3DXMatrixLookAtLH(MatView, vec3(0, 3, -5), vec3(0, 0, 0), vec3(0, 1, 0))
    Call d3dDevice.SetTransform(D3DTS_VIEW, MatView)
    
    '  
    Call D3DXMatrixPerspectiveFovLH(MatProjection, pi / 4, 1, 1, 1000)
    Call d3dDevice.SetTransform(D3DTS_PROJECTION, MatProjection)
End Sub

Private Sub Render()
    Dim v As CUSTOMVERTEX
    Dim sizeOfVertex As Long
    
    DoEvents
    
    sizeOfVertex = Len(v)
    
    If d3dDevice Is Nothing Then Exit Sub
    
    '    z-   
    Call d3dDevice.Clear(0, ByVal 0, D3DCLEAR_TARGET Or D3DCLEAR_ZBUFFER, &HFF, 1, 0)  ' 
    Call d3dDevice.BeginScene ' 
    
    '    
    d3dDevice.SetTexture 0, pTexture
    
    '   
    d3dDevice.SetTextureStageState 0, D3DTSS_COLOROP, D3DTOP_MODULATE
    d3dDevice.SetTextureStageState 0, D3DTSS_COLORARG1, D3DTA_TEXTURE
    d3dDevice.SetTextureStageState 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE
    d3dDevice.SetTextureStageState 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE
    
    '  ,   
    SetupMatrices
    
    '    ,    
    Call d3dDevice.SetStreamSource(0, pVB, sizeOfVertex)
    Call d3dDevice.SetVertexShader(D3DFVF_CUSTOMVERTEX)
    Call d3dDevice.DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, (4 * 25) - 2)
    
    Call d3dDevice.EndScene ' 
    
    '    (aka Flip)
    Call d3dDevice.Present(ByVal 0, ByVal 0, 0, ByVal 0)
End Sub



'   
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Set pTexture = Nothing
    Set pVB = Nothing
    Set d3dDevice = Nothing
    Set d3d = Nothing
End Sub

'     
Function vec3(x As Single, y As Single, z As Single) As D3DVECTOR
    vec3.x = x
    vec3.y = y
    vec3.z = z
End Function

