//**********************************************************
//        
// DirectX Graphics -  
// :   aka Anti
// 
//  ,     ,  
//     ,     
// La Vision (http://www.la-vision.net)
// 
// : <support@la-vision.net>
//
//       
//    
//**********************************************************


#include <d3dx8.h>
#include <mmsystem.h>

LPDIRECT3D8				g_pD3D = NULL; //  Direct3D
LPDIRECT3DDEVICE8		g_pd3dDevice = NULL; //               

LPD3DXMESH              g_pMesh          = NULL; //  ,    
D3DMATERIAL8*           g_pMeshMaterials = NULL; //   
LPDIRECT3DTEXTURE8*     g_pMeshTextures  = NULL; //   
DWORD                   g_dwNumMaterials = 0L;   //   


//   
VOID Cleanup();
HRESULT InitD3D( HWND hWnd );
HRESULT InitGeometry();
VOID SetupMatrices();
VOID Render();



//  Windows
LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_DESTROY:
			PostQuitMessage( 0 );
			return 0;
	}

	return DefWindowProc( hWnd, msg, wParam, lParam );
}

 

//  
INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
	//  
	WNDCLASSEX wc = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 0L,
			GetModuleHandle(NULL), NULL, NULL, NULL, NULL,
			"D3D Tutorial", NULL };
	RegisterClassEx( &wc ); 

	//  
	HWND hWnd = CreateWindow( "D3D Tutorial", "DirectX Graphics 6 - ",
			WS_OVERLAPPEDWINDOW, 0, 0, 640, 480,
			GetDesktopWindow(), NULL, wc.hInstance, NULL );

	//  Direct3D
	if( SUCCEEDED( InitD3D( hWnd ) ) )
	{
		//  
		if( SUCCEEDED( InitGeometry() ) )
		{
			//  
			ShowWindow( hWnd, SW_SHOWDEFAULT );
			UpdateWindow( hWnd );

			//     
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message!=WM_QUIT )
			{
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
				{
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}
					else
				Render();
			}
		}
	}

	//    
	Cleanup();
	UnregisterClass( "D3D Tutorial", wc.hInstance );
	return 0;
}


// Direct3D
HRESULT InitD3D( HWND hWnd )
{
	//   D3D,      
	if( NULL == ( g_pD3D = Direct3DCreate8( D3D_SDK_VERSION ) ) )
	return E_FAIL;

	//    
	D3DDISPLAYMODE d3ddm;
	if( FAILED( g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
	return E_FAIL;

	//     .  
	//   ,     
	//  
	D3DPRESENT_PARAMETERS d3dpp; 
	ZeroMemory( &d3dpp, sizeof(d3dpp) );
	d3dpp.Windowed = FALSE;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.BackBufferCount = 1;
	d3dpp.BackBufferWidth = 640;
    d3dpp.BackBufferHeight = 480;
	d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

	if( FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,
			&d3dpp, &g_pd3dDevice ) ) )
	{
	return E_FAIL;
	}


	//  Z-
	g_pd3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

	//   
    g_pd3dDevice->SetRenderState( D3DRS_AMBIENT, 0xffffffff );

	//   ,   - 
	return S_OK;
}



//           
HRESULT InitGeometry()
{
    LPD3DXBUFFER pD3DXMtrlBuffer; //  

    //     
    if( FAILED( D3DXLoadMeshFromX( "Tiger.x", D3DXMESH_SYSTEMMEM, 
                                   g_pd3dDevice, NULL, 
                                   &pD3DXMtrlBuffer, &g_dwNumMaterials, 
                                   &g_pMesh ) ) )
    {
        return E_FAIL;
    }

    //       ,   
	//  pD3DXMtrlBuffer
    
	//   
	D3DXMATERIAL* d3dxMaterials = (D3DXMATERIAL*)pD3DXMtrlBuffer->GetBufferPointer(); 
    
	//         
	g_pMeshMaterials = new D3DMATERIAL8[g_dwNumMaterials];
    g_pMeshTextures  = new LPDIRECT3DTEXTURE8[g_dwNumMaterials];

    //         
	for( DWORD i=0; i<g_dwNumMaterials; i++ )
    {
        //  
        g_pMeshMaterials[i] = d3dxMaterials[i].MatD3D;

        //     ,   D3DX   
        g_pMeshMaterials[i].Ambient = g_pMeshMaterials[i].Diffuse;
     
        //   ,    ,   
        if( FAILED( D3DXCreateTextureFromFile( g_pd3dDevice, 
                                               d3dxMaterials[i].pTextureFilename, 
                                               &g_pMeshTextures[i] ) ) )
        {
            g_pMeshTextures[i] = NULL;
        }
    }

    //   
    pD3DXMtrlBuffer->Release();

    return S_OK;
}


//    
VOID Cleanup()
{
    if( g_pMeshMaterials != NULL ) 
        delete[] g_pMeshMaterials;

    if( g_pMeshTextures )
    {
        for( DWORD i = 0; i < g_dwNumMaterials; i++ )
        {
            if( g_pMeshTextures[i] )
                g_pMeshTextures[i]->Release();
        }
        delete[] g_pMeshTextures;
    }
    if( g_pMesh != NULL )
        g_pMesh->Release();
    
    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();
}


//  ,     
VOID SetupMatrices()
{
	//   
	D3DXMATRIX matWorld;
	D3DXMatrixRotationY( &matWorld, timeGetTime()/1000.0f );
    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

	//   
	D3DXMATRIX matView;
    D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 3.0f,-5.0f ), 
                                  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ), 
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
    g_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

	//   
	D3DXMATRIX matProj;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.0f, 1.0f, 100.0f );
	g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}


//    
VOID Render()
{
    //     z-   
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
                         D3DCOLOR_XRGB(0,0,255), 1.0f, 0 );

    //   
    g_pd3dDevice->BeginScene();


    //   ,   
    SetupMatrices();

    //       .  
	//        
    for( DWORD i=0; i<g_dwNumMaterials; i++ )
    {
        //       
        g_pd3dDevice->SetMaterial( &g_pMeshMaterials[i] );
        g_pd3dDevice->SetTexture( 0, g_pMeshTextures[i] );
        
        //  
        g_pMesh->DrawSubset( i );
    }

    // 
    g_pd3dDevice->EndScene();

    //      
    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}