VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "DirectX Graphics:  6 - "
   ClientHeight    =   4500
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5730
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   300
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   382
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'//**********************************************************
'//        
'// DirectX Graphics -  
'// :   aka Anti
'//
'//  ,     , 
'//     ,    
'// La Vision (http://www.la-vision.net)
'//
'// : <support@la-vision.net>
'//
'//       
'//    
'//**********************************************************

Option Explicit

'  DirectX
Dim dx As New DirectX8 ' DirectX8
Dim d3d As Direct3D8 ' Direct3D
Dim d3dx As New D3DX8 ' Direct3DX
Dim d3dDevice As Direct3DDevice8 '  

Dim Mesh As D3DXMesh
Dim MeshMaterials() As D3DMATERIAL8
Dim MeshTextures() As Direct3DTexture8
Dim NumMaterials As Long

'  ?
Dim Running As Boolean



Private Const pi = 3.141592


'    -  
Private Sub Form_KeyPress(KeyAscii As Integer)
    Running = False
End Sub

'      Direct3D
Private Sub Form_Load()
    Me.Show ' 
    Running = True
    InitD3D ' D3D
    InitGeometry '  
    Do While Running '  
        Render
    Loop
    End
End Sub

' Direct3D
Private Sub InitD3D()
    '   
    Dim DispMode As D3DDISPLAYMODE
    Dim d3dpp As D3DPRESENT_PARAMETERS
    
    '  Direct3D
    Set d3d = dx.Direct3DCreate
    '   
    Call d3d.GetAdapterDisplayMode(D3DADAPTER_DEFAULT, DispMode)
    
    '    
    d3dpp.Windowed = False
    d3dpp.SwapEffect = D3DSWAPEFFECT_COPY_VSYNC
    d3dpp.BackBufferFormat = DispMode.Format
    d3dpp.BackBufferWidth = 640
    d3dpp.BackBufferHeight = 480
    d3dpp.BackBufferCount = 1
    d3dpp.EnableAutoDepthStencil = True
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16
    
    '  
    Set d3dDevice = d3d.CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, Me.hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, d3dpp)
    
    '  
    Call d3dDevice.SetRenderState(D3DRS_AMBIENT, &HFFFFFFFF)
    
    ' Z-
    Call d3dDevice.SetRenderState(D3DRS_ZENABLE, 1)
    
    '  D3D      
    'd3dDevice.SetRenderState D3DRS_LIGHTING, 0
    
End Sub

Private Sub InitGeometry()
    Dim D3DXMtrlBuffer As D3DXBuffer, TexName As String, I As Long
    
    Set Mesh = d3dx.LoadMeshFromX(App.Path & "\tiger.x", D3DXMESH_SYSTEMMEM, d3dDevice, _
            Nothing, D3DXMtrlBuffer, NumMaterials)
            
    If Mesh Is Nothing Then
        MsgBox "  ." & vbCrLf & "  ", vbCritical, ""
        Running = False
        Exit Sub
    End If
    
    ReDim MeshMaterials(NumMaterials)
    ReDim MeshTextures(NumMaterials)
    
    For I = 0 To NumMaterials - 1
        d3dx.BufferGetMaterial D3DXMtrlBuffer, I, MeshMaterials(I)
        MeshMaterials(I).Ambient = MeshMaterials(I).diffuse
        TexName = d3dx.BufferGetTextureName(D3DXMtrlBuffer, I)
        If TexName <> "" Then
            Set MeshTextures(I) = d3dx.CreateTextureFromFile(d3dDevice, App.Path & "\" & TexName)
        End If
    Next I
    
    Set D3DXMtrlBuffer = Nothing
End Sub

Private Sub SetupMatrices()
    Dim MatWorld As D3DMATRIX
    Dim MatView As D3DMATRIX
    Dim MatProjection As D3DMATRIX
    
    '       
    Call D3DXMatrixRotationAxis(MatWorld, vec3(0, 1, 0), Timer / 4)
    Call d3dDevice.SetTransform(D3DTS_WORLD, MatWorld)
    
    '  
    Call D3DXMatrixLookAtLH(MatView, vec3(0, 3, -5), vec3(0, 0, 0), vec3(0, 1, 0))
    Call d3dDevice.SetTransform(D3DTS_VIEW, MatView)
    
    '  
    Call D3DXMatrixPerspectiveFovLH(MatProjection, pi / 4, 1, 1, 1000)
    Call d3dDevice.SetTransform(D3DTS_PROJECTION, MatProjection)
End Sub

Private Sub Render()
    Dim I As Long
    
    DoEvents
    
    If d3dDevice Is Nothing Then Exit Sub
    
    '    z-   
    Call d3dDevice.Clear(0, ByVal 0, D3DCLEAR_TARGET Or D3DCLEAR_ZBUFFER, &HFF, 1, 0)  ' 
    
    '  ,   
    SetupMatrices
    
    Call d3dDevice.BeginScene ' 

    For I = 0 To NumMaterials - 1
        d3dDevice.SetMaterial MeshMaterials(I)
        d3dDevice.SetTexture 0, MeshTextures(I)
        
        Mesh.DrawSubset (I)
    Next I

    
    Call d3dDevice.EndScene ' 
    
    '    (aka Flip)
    Call d3dDevice.Present(ByVal 0, ByVal 0, 0, ByVal 0)
End Sub



'   
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    ReDim MeshTextures(0)
    ReDim MeshMaterials(0)
    
    Set Mesh = Nothing
    Set d3dDevice = Nothing
    Set d3d = Nothing
End Sub

'     
Function vec3(x As Single, y As Single, z As Single) As D3DVECTOR
    vec3.x = x
    vec3.y = y
    vec3.z = z
End Function

