// 3dDirect.h
//
// Copyright (c) Nigel Thompson 1996
//
// This file defines all the Direct Draw classes
//
// This file should be included in your application's main
// include file so that it is available to all modules that
// need access the the Direct Draw classes
//

#ifndef _3DDIRECT_H_
#define _3DDIRECT_H_

//////////////////////////////////////////////////////////////////
// CDDObject
//
// All direct draw objects are derived from this class
//

class CDDObject : public CObject
{
public:
	DECLARE_DYNAMIC(CDDObject);
    CDDObject();
    virtual ~CDDObject();
	HRESULT GetResult() {return m_hr;}

protected:
	HRESULT m_hr; // result of last DD system call
};
	
///////////////////////////////////////////////////////////////////
// CDDEngine
//
// This object encapsulates the global Direct Draw APIs and supports
// a single display device.
// One of these objects is automatically included in your
// application - theDDEngine.
// This implementation does not support multiple display devices.
//

class CDDEngine : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDDEngine);
    CDDEngine();
	virtual ~CDDEngine();
	int GetNumDevices();
	BOOL GetDeviceInfo(int iDev,
					   CString& strName,
					   CString& strDesc);
	HRESULT CreateDirectDraw(IDirectDraw** ppIDD);

protected:
};

// the one and only DDEngine object
extern CDDEngine theDDEngine;   

///////////////////////////////////////////////////////////////////
// CDDClipper

class CDirectDraw;

class CDDClipper : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDDClipper);
	CDDClipper();
	virtual ~CDDClipper();
	BOOL Create(CDirectDraw* pDD, HWND hWnd);
	IDirectDrawClipper* GetInterface() {return m_pIClip;}

protected:
	IDirectDrawClipper* m_pIClip;
};

///////////////////////////////////////////////////////////////////
// CDDPalette

class CDDPalette : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDDPalette);
	CDDPalette();
	CDDPalette(IDirectDrawPalette* pIPal);
	virtual ~CDDPalette();
	BOOL Create(CDirectDraw* pDD, DWORD dwFlags, PALETTEENTRY* pColorTable);
	IDirectDrawPalette* GetInterface() {return m_pIPal;}
	BOOL GetEntries(int iStart, int iCount, PALETTEENTRY* pColorTable);
	BOOL SetEntries(int iStart, int iCount, PALETTEENTRY* pColorTable);

protected:
	IDirectDrawPalette* m_pIPal;
};


///////////////////////////////////////////////////////////////////
// CDDSurface

class CDDSurface : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDDSurface);
    CDDSurface();
	CDDSurface(IDirectDrawSurface* ps);
    virtual ~CDDSurface();
	BOOL Create(CDirectDraw* pDD, DDSURFACEDESC* pDesc);
	IDirectDrawSurface* GetInterface() {return m_pISurf;}
	BOOL GetDescription(DDSURFACEDESC* pDesc);
	CDDSurface* GetAttachedSurface(DDSCAPS* pCaps);
	BOOL SetClipper(CDDClipper* pClipper);
	BOOL SetPalette(CDDPalette* pPalette);
	CDDPalette* GetPalette();
	BOOL AddAttachedSurface(CDDSurface* pSurface);
	BOOL Blt(RECT* prcTo, CDDSurface* pSurFrom, RECT* prcFrom,
			 DWORD dwFlags = DDBLT_WAIT, LPDDBLTFX lpDDBltFx = NULL);
	BOOL Flip(DWORD dwFlags = DDFLIP_WAIT);
	CDC* GetDC();
	void ReleaseDC(CDC* pDC);
	void SetColorKey(DWORD dwFlags, DDCOLORKEY* pDDColorKey);
	int GetWidth() {return m_SurfDesc.dwFlags & DDSD_WIDTH ? m_SurfDesc.dwWidth : 0;}
	int GetHeight() {return m_SurfDesc.dwFlags & DDSD_HEIGHT ? m_SurfDesc.dwHeight : 0;}
	int GetPitch() {return m_SurfDesc.dwFlags & DDSD_PITCH ? m_SurfDesc.lPitch : 0;}
	void GetRect(RECT& rc);
	int GetBitsPerPixel();
	void GetRGBMasks(DWORD& r, DWORD& g, DWORD &b);
	void* Lock();
	void Unlock();

protected:
	DDSURFACEDESC m_SurfDesc;		// cached surface description
	IDirectDrawSurface* m_pISurf;	// interface to the Direct Draw Surface object
	BOOL m_bDontDestroy;

	void _UpdateDescription();
};

///////////////////////////////////////////////////////////////////
// CDirectDraw

class CDirectDraw : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDirectDraw);
    CDirectDraw();
    virtual ~CDirectDraw();
	IDirectDraw* GetInterface() {return m_pIDD;}
	BOOL Create();
	BOOL GetCaps(DDCAPS* pDrvCaps, DDCAPS* pHelCaps = NULL);
	int GetNumModes();
	BOOL GetModeInfo(int iMode, DDSURFACEDESC* pDesc);
	BOOL SetCooperativeLevel(HWND hWnd, DWORD dwFlags);
	BOOL SetWindowedMode(HWND hWnd, int cx, int cy)
		{ return _SetMode(hWnd, cx, cy, 0, FALSE);}
	BOOL SetFullScreenMode(HWND hWnd, int cx, int cy, int bpp)
		{return _SetMode(hWnd, cx, cy, bpp, TRUE);}
	BOOL IsSWRenderOnly() {return m_bSWRender;}
	void RestoreMode();
	CDDSurface* GetBackBuffer() {return m_pBackBuffer;}
	CDDSurface* GetFrontBuffer() {return m_pFrontBuffer;}
	void OnActivate(BOOL bActive);
	CPalette* GrabPalette();
	CBitmap* GrabImage();
	HBITMAP GrabImage(BITMAPINFO** ppBMI, void** ppBits);
	CDDPalette* GetPalette() {return m_pPalette;}

protected:
	IDirectDraw* m_pIDD;
	CDDSurface* m_pFrontBuffer;
	CDDSurface* m_pBackBuffer;
	CDDClipper* m_pClipper;
	CDDPalette* m_pPalette;
	BOOL m_bSWRender;		// TRUE if not all bufs in video mem
	int m_iWidth;
	int m_iHeight;
	BOOL m_bRestore;		// TRUE if mode needs to be restored

	BOOL _SetMode(HWND hWnd, int cx, int cy, int bpp, BOOL bFullScreen);
	void _ReleaseAll();

private:
};


///////////////////////////////////////////////////////////////////
// CDirect3D

class CDirect3D : public CDDObject
{
public:
	DECLARE_DYNAMIC(CDirect3D);
    CDirect3D();
    virtual ~CDirect3D();
	BOOL Create(CDirectDraw* pDD);
	BOOL SetMode(D3DCOLORMODEL cm);
	IDirect3D* GetD3DEngine() {return m_pID3D;}
	IDirect3DDevice* GetD3DDevice() {return m_pID3DDevice;}

protected:
	CDirectDraw* m_pDD;
	IDirect3D* m_pID3D;
	IDirect3DDevice* m_pID3DDevice;
	CDDSurface* m_pZBuffer;

	BOOL _CreateZBuffer(int bpp, DWORD dwFlags);
};


#endif // _#DDIRECT_H_
