//*****************************************************************************
//**
//**
//** Name : GDebug.pas
//** Desc :     .
//**
//**

Unit GDebug;

Interface

Uses SysUtils;
Const
  LOG_OVERWRITE	=	$01; // Overwrite log file
  LOG_APPEND	=	$02; // Append to log file

//   
Function  dbg_Init(dFName : String; dMode : Integer):Boolean;
Procedure dbg_LogMes(dMsg: string; Data:Integer);
Procedure dbg_LogErr(dMsg: string; Data:Integer);
Procedure dbg_Done;

Implementation
Var
  LogFile  : Text;
  LogAvail : Boolean;

Function dbg_Init(dFName : String; dMode : Integer): boolean;
begin
  try
    AssignFile(LogFile,dFName);
    Case dMode of
      LOG_OVERWRITE : Rewrite(LogFile);
      LOG_APPEND    : Append(LogFile);
    end;
  except
//    ShowMessage('ERROR CREATING LOG-FILE!!!');
    Result := False;
    Exit;
  end;
  Writeln(LogFile,'-----------------------------['+ DateToStr(Now)+' '+ TimeToStr(Now)+']------------------------------');
  Writeln(LogFile,'-> Debug session has started successfully.');
  Result   := True;
  LogAvail := True;
  CloseFile(LogFile);

end;



Procedure dbg_LogMes(dMsg: string; Data:Integer);
begin

 if not(LogAvail) then Exit;
  try
     Append(LogFile);
     Writeln(LogFile,TimeToStr(Now)+' :> '+dMsg+'  => '  +  IntToHex(Data,4));
     CloseFile(LogFile);
  except
  end;
end;

Procedure dbg_LogErr(dMsg: string; Data:Integer);
begin

 if not(LogAvail) then Exit;
  try
     Append(LogFile);
     Writeln(LogFile,'ERROR -> '+TimeToStr(Now)+' :> '+dMsg+'  => '  +  IntToHex(Data,4));
     CloseFile(LogFile);
  except
  end;
end;

Procedure dbg_Done;
begin
  if not(LogAvail) then Exit;
  Append(LogFile);
  Writeln(LogFile,TimeToStr(Now)+' -> Debug session terminated.-----------');
  CloseFile(LogFile);
  LogAvail := False;
end;

initialization
  LogAvail := FALSE;
end.