Attribute VB_Name = "basMain"
Option Explicit

Public Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Public Declare Function ClientToScreen Lib "user32" (ByVal hwnd As Long, lpPoint As Any) As Long ' lpPoint As POINTAPI

Private Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

Private Sub Main()
    frmMain.Show
    frmMain.Run
End Sub

Public Function CreateSurfaceFromFile(DirectDraw As DirectDraw7, ByVal FileName As String, SurfaceDesc As DDSURFACEDESC2) As DirectDrawSurface7
    Dim Picture As StdPicture
    Dim Width As Long
    Dim Height As Long
    Dim Surface As DirectDrawSurface7
    Dim hdcPicture As Long  ' Picture device context
    Dim hdcSurface As Long  ' Surface device context
    ' Load picture
    Set Picture = LoadPicture(FileName)
    ' Convert from vbHimetric to vbPixels
    Width = CLng((Picture.Width * 0.001) * 567 / Screen.TwipsPerPixelX)
    Height = CLng((Picture.Height * 0.001) * 567 / Screen.TwipsPerPixelY)
    ' Update surface description
    With SurfaceDesc
        If .lFlags = 0 Then .lFlags = DDSD_CAPS
        .lFlags = .lFlags Or DDSD_WIDTH Or DDSD_HEIGHT
        If .ddsCaps.lCaps = 0 Then .ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
        If .lWidth = 0 Then .lWidth = Width
        If .lHeight = 0 Then .lHeight = Height
    End With
    ' Create surface
    Set Surface = DirectDraw.CreateSurface(SurfaceDesc)
    ' Create memory device
    hdcPicture = CreateCompatibleDC(0)
    ' Select the bitmap in this memory device
    SelectObject hdcPicture, Picture.Handle
    ' Get the surface's DC
    hdcSurface = Surface.GetDC
    ' Copy from the memory device to the DirectDrawSurface
    StretchBlt hdcSurface, 0, 0, SurfaceDesc.lWidth, SurfaceDesc.lHeight, hdcPicture, 0, 0, Width, Height, SRCCOPY
    ' Release the surface's DC
    Surface.ReleaseDC hdcSurface
    ' Release the memory device and the bitmap
    DeleteDC hdcPicture
    Set Picture = Nothing
    Set CreateSurfaceFromFile = Surface
    Set Surface = Nothing
End Function
