unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OpenGL;

type
  TMain = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    DC: HDC;
    hrc: HGLRC;
  public
  end;

var
  Main: TMain;

implementation

{$R *.DFM}

procedure TMain.FormCreate(Sender: TObject);
var
  PixelFmt: Integer;
  pfd: TPixelFormatDescriptor;
begin

     InitOpenGL;

     DC := GetDC(Handle);
     FillChar(pfd, SizeOf(pfd), 0);

     with pfd do
     begin
          nSize     := sizeof(pfd);
          nVersion  := 1;
          dwFlags   := PFD_DRAW_TO_WINDOW or
                       PFD_SUPPORT_OPENGL or
                       PFD_DOUBLEBUFFER;
          iPixelType:= PFD_TYPE_RGBA;
          cColorBits:= 24;
          cDepthBits:= 32;
          iLayerType:= PFD_MAIN_PLANE;
     end;

     PixelFmt := ChoosePixelFormat(DC, @pfd);
     SetPixelFormat(DC, PixelFmt, @pfd);
     hrc := wglCreateContext(DC);
     wglMakeCurrent(DC, hrc);

     glClearColor(0.0, 0.0, 0.0, 1.0);

     glViewport(0, 0, 400, 300);
     glMatrixMode(GL_PROJECTION);
     glLoadIdentity();

     gluOrtho2D(-1, 1, -1, 1);
     glMatrixMode(GL_MODELVIEW);

end;

procedure TMain.FormDestroy(Sender: TObject);
begin
  wglMakeCurrent(0, 0);
  wglDeleteContext(hrc);
  ReleaseDC(Handle, DC);
end;

procedure TMain.FormShow(Sender: TObject);
begin
  Width:=400;
  Height:=300;
end;

procedure TMain.FormPaint(Sender: TObject);
begin
     glClear(GL_COLOR_BUFFER_BIT);

     glBegin(GL_TRIANGLES);
         glColor3f(1.0, 0.0, 0.0); glVertex2f(-0.5, -0.5);
	 glColor3f(0.0, 1.0, 0.0); glVertex2f(0.5, -0.5);
	 glColor3f(0.0, 0.0, 1.0); glVertex2f(0.0, 0.5);
     glEnd();
     glFinish();
     SwapBuffers(wglGetCurrentDC());
end;

end.
