#include <afxwin.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "sample.h"

CSample App;
HGLRC rc;
CClientDC	*m_pDC;

int WindX, WindY;

BOOL CSample::InitInstance() {

	m_pMainWnd = new CMainWin;
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();
	return TRUE;
}

CMainWin::CMainWin()
{
    Create(NULL, "OpenGL MFC Sample");
	
    PIXELFORMATDESCRIPTOR   pfd;

    memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

    pfd.nSize =             sizeof(PIXELFORMATDESCRIPTOR);
    pfd.nVersion =          1;
    pfd.dwFlags =           PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL |
                            PFD_DOUBLEBUFFER;
    pfd.iPixelType =        PFD_TYPE_RGBA;
    pfd.cColorBits =        24;
    pfd.cRedBits =          0;
    pfd.cRedShift =         0;
    pfd.cGreenBits =        0;
    pfd.cGreenShift =       0; 
    pfd.cBlueBits =         0;
    pfd.cBlueShift =        0;
    pfd.cAlphaBits =        0;
    pfd.cAlphaShift =       0;
    pfd.cAccumBits =        0;
    pfd.cAccumRedBits =     0;
    pfd.cAccumGreenBits =   0;
    pfd.cAccumBlueBits =    0;
    pfd.cAccumAlphaBits =   0;
    pfd.cDepthBits =        32;
    pfd.cStencilBits =      0;
    pfd.cAuxBuffers =       0;
    pfd.iLayerType =        PFD_MAIN_PLANE;
    pfd.bReserved =         0;
    pfd.dwLayerMask =       0;
	pfd.dwVisibleMask =     0;
	pfd.dwDamageMask =      0;


	m_pDC = new CClientDC(this);
	HDC hdc = m_pDC->GetSafeHdc();

	int pixelFormat = ChoosePixelFormat(hdc, &pfd);
	if (pixelFormat == 0)
	{
		MessageBox("Error in Pixel format choosing!");
		return;
	}
	BOOL bresult = SetPixelFormat(hdc, pixelFormat, &pfd);
	if (!bresult)
	{
		MessageBox("Error in Pixel format registering!");
		return;
	}
	rc = wglCreateContext(hdc);
	if (!rc)
	{
		MessageBox("Error in OpenGL context create!");
		return;
	}
	wglMakeCurrent(hdc, rc);

	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);

	glViewport(0, 0, 400, 300);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluOrtho2D(-1, 1, -1, 1);
	glMatrixMode(GL_MODELVIEW);
}

BOOL CMainWin::PreCreateWindow(CREATESTRUCT &cs)
{
	cs.cx = 400;
	cs.cy = 300;
	cs.x = 200;
	cs.y = 200;
	WindX = cs.x;
	WindY = cs.y;
	cs.style = (WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_SYSMENU | WS_MINIMIZEBOX);
	return CFrameWnd::PreCreateWindow(cs);
}

afx_msg void CMainWin::OnDestroy()
{
	HDC hdc = m_pDC->GetSafeHdc();
	wglMakeCurrent(hdc, rc);
	wglDeleteContext(rc);
	CFrameWnd::OnDestroy();
}

afx_msg void CMainWin::OnPaint()
{
	CPaintDC dc(this);
	HDC hdc = m_pDC->GetSafeHdc();
	wglMakeCurrent(hdc, rc);
	glClear(GL_COLOR_BUFFER_BIT);
	
	glBegin(GL_TRIANGLES);
	  glColor3f(1.0f, 0.0f, 0.0f); glVertex2f(-0.5f, -0.5f);
	  glColor3f(0.0f, 1.0f, 0.0f); glVertex2f(0.5f, -0.5f);
	  glColor3f(0.0f, 0.0f, 1.0f); glVertex2f(0.0f, 0.5f);
	glEnd();
	glFinish();
	SwapBuffers(wglGetCurrentDC());
}

BEGIN_MESSAGE_MAP(CMainWin, CFrameWnd)
	ON_WM_PAINT()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

