/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.action;

import com.google.common.base.Strings;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.VaadinIcon;
import io.jmix.core.AccessManager;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.core.accesscontext.AccessContext;
import io.jmix.core.metamodel.model.MetaClass;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.accesscontext.UiEntityContext;
import io.jmix.flowui.action.ActionType;
import io.jmix.flowui.action.SecuredBaseAction;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.openbpm.control.entity.engine.AuthType;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.exception.EngineConnectionFailedException;
import io.openbpm.control.service.engine.EngineUiService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@ActionType(value="control_testEngineConnection")
public class TestEngineConnectionAction
extends SecuredBaseAction {
    public static final String ID = "control_testEngineConnection";
    private BpmEngine engine;
    protected Messages messages;
    protected EngineUiService engineUiService;
    protected Notifications notifications;
    protected Metadata metadata;
    protected AccessManager accessManager;

    public TestEngineConnectionAction() {
        super(ID);
    }

    public TestEngineConnectionAction(String id) {
        super(id);
        this.icon = ComponentUtils.convertToIcon((VaadinIcon)VaadinIcon.CONNECT);
    }

    public void setEngine(BpmEngine engine) {
        this.engine = engine;
    }

    @Autowired
    public void setMessages(Messages messages) {
        this.messages = messages;
        this.text = messages.getMessage("actions.TestConnection");
    }

    @Autowired
    public void setEngineUiService(EngineUiService engineUiService) {
        this.engineUiService = engineUiService;
    }

    @Autowired
    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    @Autowired
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Autowired
    public void setAccessManager(AccessManager accessManager) {
        this.accessManager = accessManager;
    }

    public void actionPerform(Component component) {
        if (this.engine != null) {
            if (!this.isValidUrl(this.engine.getBaseUrl())) {
                this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.formatMessage("", "engineNotAvailable.incorrectUrl", new Object[]{Strings.nullToEmpty((String)this.engine.getBaseUrl())})).withType(Notifications.Type.ERROR).show();
                return;
            }
            if (this.engine.getAuthEnabled().booleanValue() && this.engine.getAuthType() != null) {
                if (AuthType.BASIC == this.engine.getAuthType() && StringUtils.isEmpty((CharSequence)this.engine.getBasicAuthUsername())) {
                    this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.getMessage("engineNotAvailable.emptyAuthUsername")).withType(Notifications.Type.ERROR).show();
                    return;
                }
                if (AuthType.BASIC == this.engine.getAuthType() && StringUtils.isEmpty((CharSequence)this.engine.getBasicAuthPassword())) {
                    this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.getMessage("engineNotAvailable.emptyAuthPassword")).withType(Notifications.Type.ERROR).show();
                    return;
                }
                if (AuthType.HTTP_HEADER == this.engine.getAuthType() && StringUtils.isEmpty((CharSequence)this.engine.getHttpHeaderName())) {
                    this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.getMessage("engineNotAvailable.emptyHeaderName")).withType(Notifications.Type.ERROR).show();
                    return;
                }
            }
            try {
                this.engineUiService.getVersion(this.engine);
                this.notifications.create(this.messages.formatMessage("", "engineAvailable", new Object[]{this.engine.getBaseUrl()})).withType(Notifications.Type.SUCCESS).show();
            }
            catch (EngineConnectionFailedException e) {
                if (e.getStatusCode() > 0) {
                    this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.formatMessage("", "engineNotAvailable.description", new Object[]{e.getStatusCode()})).withType(Notifications.Type.ERROR).show();
                }
                String errorMessage = (String)StringUtils.defaultIfBlank((CharSequence)e.getResponseErrorMessage(), (CharSequence)e.getMessage());
                this.notifications.create(this.messages.getMessage("engineNotAvailable.title"), this.messages.formatMessage("", "engineNotAvailable.descriptionWithError", new Object[]{errorMessage})).withType(Notifications.Type.ERROR).show();
            }
        }
    }

    protected boolean isPermitted() {
        if (this.engine == null) {
            return false;
        }
        MetaClass metaClass = this.metadata.getClass((Object)this.engine);
        UiEntityContext entityContext = new UiEntityContext(metaClass);
        this.accessManager.applyRegisteredConstraints((AccessContext)entityContext);
        if (!entityContext.isViewPermitted()) {
            return false;
        }
        return super.isPermitted();
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

