/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.mapper;

import io.openbpm.control.entity.activity.ActivityInstanceTreeItem;
import io.openbpm.control.entity.activity.ActivityShortData;
import io.openbpm.control.entity.activity.ProcessActivityStatistics;
import io.openbpm.control.entity.dashboard.IncidentStatistics;
import io.openbpm.control.mapper.ActivityMapper;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.rest.client.model.ActivityInstanceDto;
import org.camunda.community.rest.client.model.ActivityStatisticsResultDto;
import org.camunda.community.rest.client.model.HistoricActivityInstanceDto;
import org.camunda.community.rest.client.model.IncidentStatisticsResultDto;
import org.camunda.community.rest.client.model.TransitionInstanceDto;
import org.springframework.stereotype.Component;

@Component
public class ActivityMapperImpl
extends ActivityMapper {
    public ActivityShortData fromActivityDto(HistoricActivityInstanceDto source) {
        if (source == null) {
            return null;
        }
        ActivityShortData activityShortData = this.targetClassFactory();
        activityShortData.setInternalId(source.getId());
        activityShortData.setCalledProcessInstanceId(source.getCalledProcessInstanceId());
        activityShortData.setActivityId(source.getActivityId());
        activityShortData.setActivityName(source.getActivityName());
        activityShortData.setActivityType(source.getActivityType());
        return activityShortData;
    }

    public ActivityInstanceTreeItem fromRuntimeActivityDto(ActivityInstanceDto source) {
        if (source == null) {
            return null;
        }
        ActivityInstanceTreeItem activityInstanceTreeItem = this.targetTreeItemClassFactory();
        activityInstanceTreeItem.setActivityInstanceId(source.getId());
        activityInstanceTreeItem.setProcessDefinitionId(source.getProcessDefinitionId());
        activityInstanceTreeItem.setProcessInstanceId(source.getProcessInstanceId());
        activityInstanceTreeItem.setActivityType(source.getActivityType());
        activityInstanceTreeItem.setActivityName(source.getActivityName());
        activityInstanceTreeItem.setActivityId(source.getActivityId());
        activityInstanceTreeItem.setTransition(Boolean.valueOf(false));
        return activityInstanceTreeItem;
    }

    public ActivityInstanceTreeItem fromRuntimeTransitionDto(TransitionInstanceDto source) {
        if (source == null) {
            return null;
        }
        ActivityInstanceTreeItem activityInstanceTreeItem = this.targetTreeItemClassFactory();
        activityInstanceTreeItem.setActivityInstanceId(source.getId());
        activityInstanceTreeItem.setProcessDefinitionId(source.getProcessDefinitionId());
        activityInstanceTreeItem.setProcessInstanceId(source.getProcessInstanceId());
        activityInstanceTreeItem.setActivityType(source.getActivityType());
        activityInstanceTreeItem.setActivityName(source.getActivityName());
        activityInstanceTreeItem.setActivityId(source.getActivityId());
        activityInstanceTreeItem.setTransition(Boolean.valueOf(true));
        return activityInstanceTreeItem;
    }

    public ProcessActivityStatistics fromActivityStatisticsResult(ActivityStatisticsResultDto source) {
        if (source == null) {
            return null;
        }
        ProcessActivityStatistics processActivityStatistics = this.activityStatisticsClassFactory();
        processActivityStatistics.setInstanceCount(source.getInstances());
        processActivityStatistics.setFailedJobCount(source.getFailedJobs());
        processActivityStatistics.setActivityId(source.getId());
        processActivityStatistics.setIncidents(this.incidentStatisticsResultDtoListToIncidentStatisticsList(source.getIncidents()));
        return processActivityStatistics;
    }

    public IncidentStatistics fromStatisticsResultDto(IncidentStatisticsResultDto resultDto) {
        if (resultDto == null) {
            return null;
        }
        IncidentStatistics incidentStatistics = this.incidentStatisticsClassFactory();
        incidentStatistics.setIncidentCount(resultDto.getIncidentCount());
        incidentStatistics.setIncidentType(resultDto.getIncidentType());
        return incidentStatistics;
    }

    protected List<IncidentStatistics> incidentStatisticsResultDtoListToIncidentStatisticsList(List<IncidentStatisticsResultDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IncidentStatistics> list1 = new ArrayList<IncidentStatistics>(list.size());
        for (IncidentStatisticsResultDto incidentStatisticsResultDto : list) {
            list1.add(this.fromStatisticsResultDto(incidentStatisticsResultDto));
        }
        return list1;
    }
}

