/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.mapper;

import io.openbpm.control.entity.incident.HistoricIncidentData;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.mapper.IncidentMapper;
import java.util.UUID;
import org.camunda.community.rest.client.model.HistoricIncidentDto;
import org.camunda.community.rest.client.model.IncidentDto;
import org.springframework.stereotype.Component;

@Component
public class IncidentMapperImpl
extends IncidentMapper {
    public IncidentData fromIncidentModel(IncidentDto source) {
        if (source == null) {
            return null;
        }
        IncidentData incidentData = this.targetClassFactory();
        incidentData.setType(source.getIncidentType());
        incidentData.setMessage(source.getIncidentMessage());
        incidentData.setIncidentId(source.getId());
        incidentData.setTimestamp(source.getIncidentTimestamp());
        incidentData.setActivityId(source.getActivityId());
        incidentData.setConfiguration(source.getConfiguration());
        incidentData.setJobDefinitionId(source.getJobDefinitionId());
        incidentData.setRootCauseIncidentId(source.getRootCauseIncidentId());
        incidentData.setCauseIncidentId(source.getCauseIncidentId());
        incidentData.setProcessDefinitionId(source.getProcessDefinitionId());
        incidentData.setProcessInstanceId(source.getProcessInstanceId());
        incidentData.setFailedActivityId(source.getFailedActivityId());
        incidentData.setExecutionId(source.getExecutionId());
        if (source.getId() != null) {
            incidentData.setId(UUID.fromString(source.getId()));
        }
        return incidentData;
    }

    public HistoricIncidentData fromHistoricIncidentModel(HistoricIncidentDto historicIncidentDto) {
        if (historicIncidentDto == null) {
            return null;
        }
        HistoricIncidentData historicIncidentData = this.historicIncidentTargetClassFactory();
        historicIncidentData.setType(historicIncidentDto.getIncidentType());
        historicIncidentData.setMessage(historicIncidentDto.getIncidentMessage());
        historicIncidentData.setIncidentId(historicIncidentDto.getId());
        historicIncidentData.setTenantId(historicIncidentDto.getTenantId());
        historicIncidentData.setJobDefinitionId(historicIncidentDto.getJobDefinitionId());
        historicIncidentData.setDeleted(historicIncidentDto.getDeleted());
        historicIncidentData.setResolved(historicIncidentDto.getResolved());
        historicIncidentData.setOpen(historicIncidentDto.getOpen());
        historicIncidentData.setEndTime(historicIncidentDto.getEndTime());
        historicIncidentData.setCreateTime(historicIncidentDto.getCreateTime());
        historicIncidentData.setConfiguration(historicIncidentDto.getConfiguration());
        historicIncidentData.setRootCauseIncidentId(historicIncidentDto.getRootCauseIncidentId());
        historicIncidentData.setCauseIncidentId(historicIncidentDto.getCauseIncidentId());
        historicIncidentData.setActivityId(historicIncidentDto.getActivityId());
        historicIncidentData.setProcessInstanceId(historicIncidentDto.getProcessInstanceId());
        historicIncidentData.setProcessDefinitionId(historicIncidentDto.getProcessDefinitionId());
        historicIncidentData.setProcessDefinitionKey(historicIncidentDto.getProcessDefinitionKey());
        if (historicIncidentDto.getId() != null) {
            historicIncidentData.setId(UUID.fromString(historicIncidentDto.getId()));
        }
        return historicIncidentData;
    }
}

