/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.mapper;

import io.jmix.core.Metadata;
import io.openbpm.control.entity.variable.HistoricVariableInstanceData;
import io.openbpm.control.entity.variable.ObjectTypeInfo;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.entity.variable.VariableValueInfo;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Map;
import org.camunda.community.rest.client.model.HistoricVariableInstanceDto;
import org.camunda.community.rest.client.model.VariableInstanceDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

@Mapper(componentModel="spring")
public abstract class VariableMapper {
    @Autowired
    Metadata metadata;

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="historicVariableInstanceId", source="id"), @Mapping(target="valueInfo", expression="java(createValueInfo(source.getValueInfo()))")})
    public abstract HistoricVariableInstanceData fromHistoricVariableInstanceDto(HistoricVariableInstanceDto var1);

    HistoricVariableInstanceData targetClassFactory() {
        return (HistoricVariableInstanceData)this.metadata.create(HistoricVariableInstanceData.class);
    }

    @Mappings(value={@Mapping(target="id", source="id"), @Mapping(target="variableInstanceId", source="id"), @Mapping(target="valueInfo", expression="java(createValueInfo(source.getValueInfo()))")})
    public abstract VariableInstanceData fromVariableDto(VariableInstanceDto var1);

    VariableInstanceData runtimeVariableTargetClassFactory() {
        return (VariableInstanceData)this.metadata.create(VariableInstanceData.class);
    }

    @Nullable
    public VariableValueInfo createValueInfo(Map<String, Object> valueInfoMap) {
        if (valueInfoMap != null && !valueInfoMap.isEmpty()) {
            VariableValueInfo variableValueInfo = (VariableValueInfo)this.metadata.create(VariableValueInfo.class);
            ObjectTypeInfo objectTypeInfo = (ObjectTypeInfo)this.metadata.create(ObjectTypeInfo.class);
            objectTypeInfo.setObjectTypeName((String)valueInfoMap.get("objectTypeName"));
            objectTypeInfo.setSerializationDataFormat((String)valueInfoMap.get("serializationDataFormat"));
            variableValueInfo.setObject(objectTypeInfo);
            variableValueInfo.setEncoding((String)valueInfoMap.get("encoding"));
            variableValueInfo.setFilename((String)valueInfoMap.get("filename"));
            variableValueInfo.setMimeType((String)valueInfoMap.get("mimeType"));
            return variableValueInfo;
        }
        return null;
    }

    Date map(OffsetDateTime value) {
        if (value == null) {
            return null;
        }
        Instant instant = value.toInstant();
        return Date.from(instant);
    }
}

