/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.restsupport.camunda;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import io.openbpm.control.exception.RemoteEngineParseException;
import io.openbpm.control.exception.RemoteProcessEngineException;
import io.openbpm.control.restsupport.camunda.CamundaErrorResponse;
import io.openbpm.control.restsupport.camunda.ParseExceptionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.camunda.community.rest.config.CamundaRestClientProperties;
import org.camunda.community.rest.config.ErrorDecoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class CamundaFeignErrorDecoder
implements ErrorDecoder {
    protected static final Logger log = LoggerFactory.getLogger(CamundaFeignErrorDecoder.class);
    protected final CamundaRestClientProperties camundaRestClientProperties;
    protected final ErrorDecoder defaultErrorDecoder;
    protected final ObjectMapper objectMapper;

    public CamundaFeignErrorDecoder(CamundaRestClientProperties camundaRestClientProperties) {
        this.camundaRestClientProperties = camundaRestClientProperties;
        this.objectMapper = new ObjectMapper();
        this.defaultErrorDecoder = new ErrorDecoder.Default();
    }

    public Exception decode(String methodKey, Response response) {
        ErrorDecoding errorDecoding = this.camundaRestClientProperties.getErrorDecoding();
        List httpCodes = errorDecoding.getHttpCodes();
        if (httpCodes.contains(response.status())) {
            Exception decodedException = this.decodeException(response);
            if (decodedException != null) {
                if (errorDecoding.getWrapExceptions() && !(decodedException instanceof RemoteProcessEngineException)) {
                    return new RemoteProcessEngineException("Error during remote BPM engine engine invocation", (Throwable)decodedException);
                }
                return decodedException;
            }
            return new RemoteProcessEngineException("Error during remote BPM engine invocation of %s: %s".formatted(methodKey, response.reason()));
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }

    protected Exception decodeException(Response feignResponse) {
        try {
            String responseContent = IOUtils.toString((InputStream)feignResponse.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
            CamundaErrorResponse errorResponse = (CamundaErrorResponse)this.objectMapper.readValue(responseContent, CamundaErrorResponse.class);
            String type = errorResponse.getType();
            Exception exceptionFromResponse = type.equals("ParseException") ? this.createParseException(responseContent) : this.createExceptionByType(errorResponse);
            return exceptionFromResponse != null ? exceptionFromResponse : RemoteProcessEngineException.defaultException((CamundaErrorResponse)errorResponse);
        }
        catch (IOException e) {
            log.error("Unable to parse error response from BPM engine: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    protected Exception createExceptionByType(CamundaErrorResponse errorResponse) {
        try {
            Class<?> exceptionClass = Class.forName(errorResponse.getType());
            if (Throwable.class.isAssignableFrom(exceptionClass)) {
                Constructor<?> constructor = exceptionClass.getConstructor(String.class);
                return (Exception)constructor.newInstance(errorResponse.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            log.debug("Unable to create exception by returned type {}: {}", new Object[]{errorResponse.getType(), e.getMessage(), e});
            return null;
        }
    }

    @Nullable
    protected Exception createParseException(String responseContent) {
        try {
            ParseExceptionResponse parseExceptionResponse = (ParseExceptionResponse)this.objectMapper.readValue(responseContent, ParseExceptionResponse.class);
            return new RemoteEngineParseException(parseExceptionResponse.getMessage(), parseExceptionResponse.getDetails());
        }
        catch (JsonProcessingException e) {
            log.error("Unable to parse exception response from BPM engine: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

