/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.decisioninstance.impl;

import feign.utils.ExceptionUtils;
import io.jmix.core.Sort;
import io.openbpm.control.entity.decisioninstance.HistoricDecisionInstanceShortData;
import io.openbpm.control.entity.filter.DecisionInstanceFilter;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.DecisionInstanceMapper;
import io.openbpm.control.service.decisioninstance.DecisionInstanceLoadContext;
import io.openbpm.control.service.decisioninstance.DecisionInstanceService;
import io.openbpm.control.service.decisioninstance.impl.HistoricDecisionInstanceQueryImpl;
import io.openbpm.control.util.QueryUtils;
import java.net.ConnectException;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_DecisionInstanceService")
public class DecisionInstanceServiceImpl
implements DecisionInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionInstanceServiceImpl.class);
    protected final HistoryApiClient historyApiClient;
    protected final DecisionInstanceMapper decisionInstanceMapper;

    public DecisionInstanceServiceImpl(HistoryApiClient historyApiClient, DecisionInstanceMapper decisionInstanceMapper) {
        this.historyApiClient = historyApiClient;
        this.decisionInstanceMapper = decisionInstanceMapper;
    }

    public List<HistoricDecisionInstanceShortData> findAllHistoryDecisionInstances(DecisionInstanceLoadContext loadContext) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = this.createHistoricDecisionInstanceQuery((DecisionInstanceFilter)loadContext.getFilter(), loadContext.getSort());
        try {
            List historicDecisionInstances = loadContext.getFirstResult() != null && loadContext.getMaxResults() != null ? decisionInstanceQuery.listPage(loadContext.getFirstResult().intValue(), loadContext.getMaxResults().intValue()) : decisionInstanceQuery.list();
            return historicDecisionInstances.stream().map(arg_0 -> ((DecisionInstanceMapper)this.decisionInstanceMapper).fromHistoricDecisionInstance(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load deployments because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load deployments because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public long getHistoryDecisionInstancesCount(DecisionInstanceFilter filter) {
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.createHistoricDecisionInstanceQuery(filter, null);
        return historicDecisionInstanceQuery.count();
    }

    public HistoricDecisionInstanceShortData getById(String decisionInstanceId) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = this.createHistoricDecisionInstanceQuery().decisionInstanceId(decisionInstanceId).includeInputs().includeOutputs();
        try {
            return decisionInstanceQuery.list().stream().map(arg_0 -> ((DecisionInstanceMapper)this.decisionInstanceMapper).fromHistoricDecisionInstance(arg_0)).findFirst().orElse(null);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load deployments because BPM engine not selected");
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load deployments because of connection error: ", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    public long getCountByDecisionDefinitionId(String decisionDefinitionId) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = this.createHistoricDecisionInstanceQuery().decisionDefinitionId(decisionDefinitionId);
        return decisionInstanceQuery.count();
    }

    public long getCountByDecisionDefinitionKey(String decisionDefinitionKey) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = this.createHistoricDecisionInstanceQuery().decisionDefinitionKey(decisionDefinitionKey);
        return decisionInstanceQuery.count();
    }

    protected HistoricDecisionInstanceQuery createHistoricDecisionInstanceQuery(@Nullable DecisionInstanceFilter filter, @Nullable Sort sort) {
        HistoricDecisionInstanceQueryImpl historicDecisionInstanceQuery = new HistoricDecisionInstanceQueryImpl(this.historyApiClient);
        QueryUtils.addDecisionInstanceFilters((HistoricDecisionInstanceQuery)historicDecisionInstanceQuery, (DecisionInstanceFilter)filter);
        QueryUtils.addDecisionInstanceSort((HistoricDecisionInstanceQuery)historicDecisionInstanceQuery, (Sort)sort);
        return historicDecisionInstanceQuery;
    }

    protected HistoricDecisionInstanceQuery createHistoricDecisionInstanceQuery() {
        return this.createHistoricDecisionInstanceQuery(null, null);
    }
}

