/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.engine.impl;

import io.jmix.core.DataManager;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.core.SaveContext;
import io.jmix.core.Sort;
import io.jmix.core.querycondition.Condition;
import io.jmix.core.querycondition.PropertyCondition;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.core.session.SessionData;
import io.jmix.flowui.UiEventPublisher;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.service.engine.EngineService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Service;

@Service(value="control_EngineService")
public class EngineServiceImpl
implements EngineService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EngineServiceImpl.class);
    protected final Metadata metadata;
    protected final ObjectProvider<SessionData> sessionDataProvider;
    protected final DataManager dataManager;
    protected final UiEventPublisher uiEventPublisher;
    protected final CurrentAuthentication currentAuthentication;

    public EngineServiceImpl(Metadata metadata, ObjectProvider<SessionData> sessionDataProvider, UiEventPublisher uiEventPublisher, CurrentAuthentication currentAuthentication, DataManager dataManager) {
        this.metadata = metadata;
        this.sessionDataProvider = sessionDataProvider;
        this.uiEventPublisher = uiEventPublisher;
        this.currentAuthentication = currentAuthentication;
        this.dataManager = dataManager;
    }

    public BpmEngine getSelectedEngine() {
        String sessionAttribute = (String)((SessionData)this.sessionDataProvider.getObject()).getAttribute("selectedEngine");
        if (sessionAttribute == null) {
            return this.findDefaultEngine();
        }
        Optional foundBpmEngine = this.dataManager.load(BpmEngine.class).id((Object)UUID.fromString(sessionAttribute)).optional();
        return foundBpmEngine.orElseGet(() -> this.findDefaultEngine());
    }

    public BpmEngine findDefaultEngine() {
        Optional defaultEngine = this.dataManager.load(BpmEngine.class).condition((Condition)PropertyCondition.equal((String)"isDefault", (Object)true)).optional();
        return defaultEngine.orElseGet(() -> this.dataManager.load(BpmEngine.class).all().maxResults(1).sort(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createdDate"})).optional().orElse(null));
    }

    public BpmEngine findEngineByUuid(UUID uuid) {
        Optional bpmEngine = this.dataManager.load(BpmEngine.class).condition((Condition)PropertyCondition.equal((String)"id", (Object)uuid)).optional();
        return bpmEngine.orElse(null);
    }

    public void setSelectedEngine(BpmEngine engine) {
        ((SessionData)this.sessionDataProvider.getObject()).setAttribute("selectedEngine", (Object)engine.getId().toString());
    }

    public boolean engineExists() {
        long engineCount = this.dataManager.getCount(new LoadContext(this.metadata.getClass(BpmEngine.class)));
        return engineCount > 0L;
    }

    public Set<Object> saveEngine(BpmEngine engine) {
        SaveContext saveContext = new SaveContext().saving(new Object[]{engine});
        if (BooleanUtils.isTrue((Boolean)engine.getIsDefault())) {
            List defaultEngines = this.dataManager.load(BpmEngine.class).condition((Condition)PropertyCondition.equal((String)"isDefault", (Object)true)).list();
            defaultEngines.forEach(bpmEngine -> {
                bpmEngine.setIsDefault(Boolean.valueOf(false));
                saveContext.saving(new Object[]{bpmEngine});
            });
        }
        return this.dataManager.save(saveContext);
    }

    public void markAsDefault(BpmEngine engine) {
        engine.setIsDefault(Boolean.valueOf(true));
        this.saveEngine(engine);
    }
}

