/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.incident.impl;

import feign.utils.ExceptionUtils;
import io.jmix.core.Messages;
import io.jmix.core.Sort;
import io.openbpm.control.dto.ActivityIncidentData;
import io.openbpm.control.entity.filter.IncidentFilter;
import io.openbpm.control.entity.incident.HistoricIncidentData;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.IncidentMapper;
import io.openbpm.control.service.incident.IncidentLoadContext;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.util.EngineRestUtils;
import java.net.ConnectException;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.IncidentApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricIncidentDto;
import org.camunda.community.rest.client.model.IncidentDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_IncidentService")
public class IncidentServiceImpl
implements IncidentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncidentServiceImpl.class);
    protected final IncidentApiClient incidentApiClient;
    protected final HistoryApiClient historyApiClient;
    protected final IncidentMapper incidentMapper;
    protected final Messages messages;

    public IncidentServiceImpl(IncidentApiClient incidentApiClient, HistoryApiClient historyApiClient, IncidentMapper incidentMapper, Messages messages) {
        this.incidentApiClient = incidentApiClient;
        this.historyApiClient = historyApiClient;
        this.incidentMapper = incidentMapper;
        this.messages = messages;
    }

    public List<ActivityIncidentData> findRuntimeIncidents(String processInstanceId) {
        ResponseEntity response = this.incidentApiClient.getIncidents(null, null, null, null, null, null, processInstanceId, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
            List incidents = Optional.ofNullable((List)response.getBody()).orElse(List.of());
            return incidents.stream().collect(Collectors.groupingBy(IncidentDto::getActivityId, Collectors.counting())).entrySet().stream().map(entry -> {
                int incidentCount = ((Long)entry.getValue()).intValue();
                return new ActivityIncidentData((String)entry.getKey(), Integer.valueOf(incidentCount));
            }).toList();
        }
        log.error("Error on loading incidents by process instance {}, status code {}", (Object)processInstanceId, (Object)response.getStatusCode());
        return List.of();
    }

    public List<IncidentData> findRuntimeIncidents(IncidentLoadContext loadContext) {
        try {
            IncidentFilter filter;
            ResponseEntity response;
            String sortBy = this.getRuntimeIncidentSortProperty(loadContext.getSort());
            String sortOrder = null;
            if (sortBy != null) {
                sortOrder = this.getIncidentSortOrder(loadContext.getSort());
            }
            if ((response = this.incidentApiClient.getIncidents(this.getIncidentId(filter = (IncidentFilter)loadContext.getFilter()), this.getIncidentType(filter), null, this.getIncidentMessageLike(filter), this.getProcessDefinitionId(filter), this.getProcessDefinitionKey(filter), this.getProcessInstanceId(filter), null, this.getTimestampBefore(filter), this.getTimestampAfter(filter), this.getActivityId(filter), null, null, null, null, null, null, sortBy, sortOrder, loadContext.getFirstResult(), loadContext.getMaxResults())).getStatusCode().is2xxSuccessful() && response.hasBody()) {
                List incidents = Optional.ofNullable((List)response.getBody()).orElse(List.of());
                return incidents.stream().map(arg_0 -> ((IncidentMapper)this.incidentMapper).fromIncidentModel(arg_0)).toList();
            }
            log.error("Error on incidents loading, status code {}", (Object)response.getStatusCode());
            return List.of();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load runtime incidents because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load runtime incidents because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public IncidentData findRuntimeIncidentById(String incidentId) {
        try {
            ResponseEntity response = this.incidentApiClient.getIncident(incidentId);
            if (response.getStatusCode().is2xxSuccessful()) {
                IncidentDto incidentDto = (IncidentDto)response.getBody();
                return incidentDto != null ? this.incidentMapper.fromIncidentModel(incidentDto) : null;
            }
            log.error("Error on loading incident by id {}, status code {}", (Object)incidentId, (Object)response.getStatusCode());
            return null;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load runtime incident by id {} because BPM engine not selected", (Object)incidentId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load runtime incident by id '{}' because of connection error: ", (Object)incidentId, (Object)e);
                return null;
            }
            throw e;
        }
    }

    public long getRuntimeIncidentCount(IncidentFilter filter) {
        ResponseEntity response = this.incidentApiClient.getIncidentsCount(this.getIncidentId(filter), this.getIncidentType(filter), null, this.getIncidentMessageLike(filter), this.getProcessDefinitionId(filter), this.getProcessDefinitionKey(filter), this.getProcessInstanceId(filter), null, this.getTimestampBefore(filter), this.getTimestampAfter(filter), this.getActivityId(filter), null, null, null, null, null, null);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error on incident count loading, status code {}", (Object)response.getStatusCode());
        return 0L;
    }

    public List<HistoricIncidentData> findHistoricIncidents(IncidentLoadContext loadContext) {
        IncidentFilter filter;
        ResponseEntity response;
        String sortBy = this.getHistoryIncidentSortProperty(loadContext.getSort());
        String sortOrder = null;
        if (sortBy != null) {
            sortOrder = this.getIncidentSortOrder(loadContext.getSort());
        }
        if ((response = this.historyApiClient.getHistoricIncidents(this.getIncidentId(filter = (IncidentFilter)loadContext.getFilter()), this.getIncidentType(filter), null, this.getIncidentMessageLike(filter), this.getProcessDefinitionId(filter), this.getProcessDefinitionKey(filter), null, this.getProcessInstanceId(filter), null, null, null, null, null, this.getActivityId(filter), null, null, null, null, null, null, null, null, null, null, null, sortBy, sortOrder, loadContext.getFirstResult(), loadContext.getMaxResults())).getStatusCode().is2xxSuccessful() && response.hasBody()) {
            List incidents = Optional.ofNullable((List)response.getBody()).orElse(List.of());
            return incidents.stream().map(arg_0 -> ((IncidentMapper)this.incidentMapper).fromHistoricIncidentModel(arg_0)).toList();
        }
        return List.of();
    }

    public long getHistoricIncidentCount(@Nullable IncidentFilter filter) {
        ResponseEntity response = this.historyApiClient.getHistoricIncidentsCount(this.getIncidentId(filter), this.getIncidentType(filter), null, this.getIncidentMessageLike(filter), this.getProcessDefinitionId(filter), this.getProcessDefinitionKey(filter), null, this.getProcessInstanceId(filter), null, null, null, null, null, this.getActivityId(filter), null, null, null, null, null, null, null, null, null, null, null);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error on historic incident count loading, status code {}", (Object)response.getStatusCode());
        return 0L;
    }

    @Nullable
    public HistoricIncidentData findHistoricIncidentById(String id) {
        ResponseEntity response = this.historyApiClient.getHistoricIncidents(id, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            List historicIncidentDtos = (List)response.getBody();
            if (CollectionUtils.isNotEmpty((Collection)historicIncidentDtos)) {
                HistoricIncidentDto incidentDto = (HistoricIncidentDto)historicIncidentDtos.get(0);
                return this.incidentMapper.fromHistoricIncidentModel(incidentDto);
            }
            return null;
        }
        log.error("Error on loading historic incident by id {}, status code {}", (Object)id, (Object)response.getStatusCode());
        return null;
    }

    protected String getRuntimeIncidentSortProperty(@Nullable Sort sort) {
        if (sort == null || sort.getOrders().isEmpty()) {
            return null;
        }
        Sort.Order order = (Sort.Order)sort.getOrders().get(0);
        return switch (order.getProperty()) {
            case "id" -> "incidentId";
            case "type" -> "incidentType";
            case "timestamp" -> "incidentTimestamp";
            case "message" -> "incidentMessage";
            case "processInstanceId" -> "processInstanceId";
            case "processDefinitionId" -> "processDefinitionId";
            case "activityId" -> "activityId";
            default -> null;
        };
    }

    protected String getHistoryIncidentSortProperty(@Nullable Sort sort) {
        if (sort == null || sort.getOrders().isEmpty()) {
            return null;
        }
        Sort.Order order = (Sort.Order)sort.getOrders().get(0);
        return switch (order.getProperty()) {
            case "id" -> "incidentId";
            case "type" -> "incidentType";
            case "createTime" -> "createTime";
            case "endTime" -> "endTime";
            case "message" -> "incidentMessage";
            case "activityId" -> "activityId";
            case "resolved" -> "incidentState";
            default -> null;
        };
    }

    protected String getIncidentSortOrder(@Nullable Sort sort) {
        if (sort == null || sort.getOrders().isEmpty()) {
            return null;
        }
        Sort.Order order = (Sort.Order)sort.getOrders().get(0);
        Sort.Direction direction = order.getDirection();
        if (direction == Sort.Direction.ASC) {
            return "asc";
        }
        if (direction == Sort.Direction.DESC) {
            return "desc";
        }
        return null;
    }

    @Nullable
    protected String getProcessInstanceId(@Nullable IncidentFilter filter) {
        return filter != null ? filter.getProcessInstanceId() : null;
    }

    @Nullable
    protected String getIncidentId(@Nullable IncidentFilter filter) {
        return filter != null ? filter.getIncidentId() : null;
    }

    @Nullable
    protected String getIncidentType(@Nullable IncidentFilter filter) {
        return filter != null ? filter.getIncidentType() : null;
    }

    @Nullable
    protected String getProcessDefinitionId(@Nullable IncidentFilter filter) {
        return filter != null ? filter.getProcessDefinitionId() : null;
    }

    @Nullable
    protected String getProcessDefinitionKey(@Nullable IncidentFilter filter) {
        return filter != null ? filter.getProcessDefinitionKey() : null;
    }

    @Nullable
    protected String getIncidentMessageLike(@Nullable IncidentFilter filter) {
        return filter != null && filter.getIncidentMessageLike() != null ? "%" + filter.getIncidentMessageLike() + "%" : null;
    }

    @Nullable
    protected String getActivityId(IncidentFilter filter) {
        return filter != null ? filter.getActivityId() : null;
    }

    @Nullable
    protected OffsetDateTime getTimestampBefore(IncidentFilter filter) {
        return filter != null ? filter.getIncidentTimestampBefore() : null;
    }

    @Nullable
    protected OffsetDateTime getTimestampAfter(IncidentFilter filter) {
        return filter != null ? filter.getIncidentTimestampAfter() : null;
    }
}

