/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.variable.impl;

import io.jmix.core.EntityStates;
import io.jmix.core.Sort;
import io.openbpm.control.entity.filter.VariableFilter;
import io.openbpm.control.entity.variable.HistoricVariableInstanceData;
import io.openbpm.control.entity.variable.ObjectTypeInfo;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.mapper.VariableMapper;
import io.openbpm.control.service.client.EngineRestClient;
import io.openbpm.control.service.engine.EngineService;
import io.openbpm.control.service.variable.VariableLoadContext;
import io.openbpm.control.service.variable.VariableService;
import io.openbpm.control.util.EngineRestUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.ProcessInstanceApiClient;
import org.camunda.community.rest.client.api.VariableInstanceApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricVariableInstanceDto;
import org.camunda.community.rest.client.model.HistoricVariableInstanceQueryDto;
import org.camunda.community.rest.client.model.HistoricVariableInstanceQueryDtoSortingInner;
import org.camunda.community.rest.client.model.VariableInstanceDto;
import org.camunda.community.rest.client.model.VariableInstanceQueryDto;
import org.camunda.community.rest.client.model.VariableInstanceQueryDtoSortingInner;
import org.camunda.community.rest.client.model.VariableValueDto;
import org.camunda.community.rest.impl.RemoteRuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_VariableService")
public class VariableServiceImpl
implements VariableService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VariableServiceImpl.class);
    protected final HistoryApiClient historyApiClient;
    protected final VariableMapper variableMapper;
    protected final RemoteRuntimeService remoteRuntimeService;
    protected final VariableInstanceApiClient variableInstanceApiClient;
    protected final ProcessInstanceApiClient processInstanceApiClient;
    protected final EntityStates entityStates;
    protected final EngineService engineService;
    protected final EngineRestClient engineRestClient;

    public VariableServiceImpl(HistoryApiClient historyApiClient, VariableMapper variableMapper, RemoteRuntimeService remoteRuntimeService, VariableInstanceApiClient variableInstanceApiClient, ProcessInstanceApiClient processInstanceApiClient, EntityStates entityStates, EngineService engineService, EngineRestClient engineRestClient) {
        this.historyApiClient = historyApiClient;
        this.variableMapper = variableMapper;
        this.remoteRuntimeService = remoteRuntimeService;
        this.variableInstanceApiClient = variableInstanceApiClient;
        this.processInstanceApiClient = processInstanceApiClient;
        this.entityStates = entityStates;
        this.engineService = engineService;
        this.engineRestClient = engineRestClient;
    }

    public List<VariableInstanceData> findRuntimeVariables(VariableLoadContext loadContext) {
        ResponseEntity response;
        VariableInstanceQueryDto queryDto = this.createVariableInstanceQuery((VariableFilter)loadContext.getFilter());
        Sort sort = loadContext.getSort();
        if (sort != null) {
            List sortDtoList = this.createSortDtoList(sort);
            queryDto.setSorting(sortDtoList);
        }
        if ((response = this.variableInstanceApiClient.queryVariableInstances(loadContext.getFirstResult(), loadContext.getMaxResults(), Boolean.valueOf(false), queryDto)).getStatusCode().is2xxSuccessful()) {
            return CollectionUtils.emptyIfNull((Collection)((Collection)response.getBody())).stream().map(variableInstanceDto -> {
                VariableInstanceData variableInstanceData = this.variableMapper.fromVariableDto(variableInstanceDto);
                this.entityStates.setNew((Object)variableInstanceData, false);
                return variableInstanceData;
            }).toList();
        }
        log.error("Error on loading runtime variables, query {}, status code {}", (Object)queryDto, (Object)response.getStatusCode());
        return List.of();
    }

    public VariableInstanceData findRuntimeVariableById(String variableInstanceId) {
        ResponseEntity response = this.variableInstanceApiClient.getVariableInstance(variableInstanceId, Boolean.valueOf(false));
        if (response.getStatusCode().is2xxSuccessful()) {
            VariableInstanceDto variableInstanceDto = (VariableInstanceDto)response.getBody();
            return variableInstanceDto != null ? this.variableMapper.fromVariableDto(variableInstanceDto) : null;
        }
        log.error("Error on loading runtime variables, variable id {}, status code {}", (Object)variableInstanceId, (Object)response.getStatusCode());
        return null;
    }

    public Resource getVariableInstanceBinary(String variableInstanceId) {
        ResponseEntity response = this.variableInstanceApiClient.getVariableInstanceBinary(variableInstanceId);
        if (response.getStatusCode().is2xxSuccessful()) {
            return (Resource)response.getBody();
        }
        return null;
    }

    public List<HistoricVariableInstanceData> findHistoricVariables(VariableLoadContext loadContext) {
        ResponseEntity response;
        HistoricVariableInstanceQueryDto queryDto = this.createHistoricVariableQuery((VariableFilter)loadContext.getFilter());
        Sort sort = loadContext.getSort();
        if (sort != null) {
            List sortDtoList = this.createHistoricVariableSortOptions(sort);
            queryDto.setSorting(sortDtoList);
        }
        if ((response = this.historyApiClient.queryHistoricVariableInstances(loadContext.getFirstResult(), loadContext.getMaxResults(), Boolean.valueOf(true), queryDto)).getStatusCode().is2xxSuccessful()) {
            return CollectionUtils.emptyIfNull((Collection)((Collection)response.getBody())).stream().map(arg_0 -> ((VariableMapper)this.variableMapper).fromHistoricVariableInstanceDto(arg_0)).toList();
        }
        log.error("Error on loading historic variables, query {}, status code {}", (Object)queryDto, (Object)response.getStatusCode());
        return List.of();
    }

    public long getRuntimeVariablesCount(@Nullable VariableFilter filter) {
        VariableInstanceQueryDto queryDto = this.createVariableInstanceQuery(filter);
        ResponseEntity response = this.variableInstanceApiClient.queryVariableInstancesCount(queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error on loading runtime variables count, query {}, status code {}", (Object)queryDto, (Object)response.getStatusCode());
        return 0L;
    }

    public long getHistoricVariablesCount(@Nullable VariableFilter filter) {
        HistoricVariableInstanceQueryDto queryDto = this.createHistoricVariableQuery(filter);
        ResponseEntity response = this.historyApiClient.queryHistoricVariableInstancesCount(queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error on loading historic variables count, query {}, status code {}", (Object)queryDto, (Object)response.getStatusCode());
        return 0L;
    }

    public void updateVariableLocal(VariableInstanceData variableInstanceData) {
        Objects.requireNonNull(variableInstanceData.getExecutionId(), "executionId can not be null");
        VariableValueDto variableValueDto = new VariableValueDto();
        variableValueDto.type(variableInstanceData.getType());
        if (variableInstanceData.getValueInfo() != null && variableInstanceData.getValueInfo().getObject() != null) {
            ObjectTypeInfo objectTypeInfo = variableInstanceData.getValueInfo().getObject();
            HashMap<String, String> valueInfoMap = new HashMap<String, String>();
            valueInfoMap.put("objectTypeName", objectTypeInfo.getObjectTypeName());
            valueInfoMap.put("serializationDataFormat", objectTypeInfo.getSerializationDataFormat());
            variableValueDto.valueInfo(valueInfoMap);
        }
        variableValueDto.value(variableInstanceData.getValue());
        this.processInstanceApiClient.setProcessInstanceVariable(variableInstanceData.getExecutionId(), variableInstanceData.getName(), variableValueDto);
    }

    public HistoricVariableInstanceData findHistoricVariableById(String variableInstanceId) {
        ResponseEntity response = this.historyApiClient.getHistoricVariableInstance(variableInstanceId, Boolean.valueOf(true));
        if (response.getStatusCode().is2xxSuccessful()) {
            HistoricVariableInstanceDto variableInstanceDto = (HistoricVariableInstanceDto)response.getBody();
            return variableInstanceDto != null ? this.variableMapper.fromHistoricVariableInstanceDto(variableInstanceDto) : null;
        }
        log.error("Error on find historic variable, variable id {}, status code {}", (Object)variableInstanceId, (Object)response.getStatusCode());
        return null;
    }

    public void removeVariableLocal(VariableInstanceData variableInstanceData) {
        Objects.requireNonNull(variableInstanceData.getExecutionId(), "executionId can not be null");
        this.remoteRuntimeService.removeVariableLocal(variableInstanceData.getExecutionId(), variableInstanceData.getName());
    }

    public void removeVariablesLocal(String executionId, Set<VariableInstanceData> variableItems) {
        Objects.requireNonNull(executionId, "executionId can not be null");
        List<String> nameList = variableItems.stream().map(VariableInstanceData::getName).toList();
        this.remoteRuntimeService.removeVariablesLocal(executionId, nameList);
    }

    public void updateVariableBinary(VariableInstanceData variableInstanceData, File data) {
        this.engineRestClient.updateVariableBinary(variableInstanceData, data);
    }

    protected List<VariableInstanceQueryDtoSortingInner> createSortDtoList(Sort sort) {
        ArrayList<VariableInstanceQueryDtoSortingInner> sortDtoList = new ArrayList<VariableInstanceQueryDtoSortingInner>();
        for (Sort.Order order : sort.getOrders()) {
            String property = order.getProperty();
            VariableInstanceQueryDtoSortingInner sortDto = new VariableInstanceQueryDtoSortingInner();
            switch (property) {
                case "name": {
                    sortDto.setSortBy(VariableInstanceQueryDtoSortingInner.SortByEnum.VARIABLE_NAME);
                    break;
                }
                case "activityInstanceId": {
                    sortDto.setSortBy(VariableInstanceQueryDtoSortingInner.SortByEnum.ACTIVITY_INSTANCE_ID);
                    break;
                }
                case "type": {
                    sortDto.setSortBy(VariableInstanceQueryDtoSortingInner.SortByEnum.VARIABLE_TYPE);
                    break;
                }
            }
            if (order.getDirection() == Sort.Direction.ASC) {
                sortDto.setSortOrder(VariableInstanceQueryDtoSortingInner.SortOrderEnum.ASC);
            } else if (order.getDirection() == Sort.Direction.DESC) {
                sortDto.setSortOrder(VariableInstanceQueryDtoSortingInner.SortOrderEnum.DESC);
            }
            if (sortDto.getSortBy() == null || sortDto.getSortOrder() == null) continue;
            sortDtoList.add(sortDto);
        }
        return sortDtoList;
    }

    protected HistoricVariableInstanceQueryDto createHistoricVariableQuery(@Nullable VariableFilter filter) {
        HistoricVariableInstanceQueryDto queryDto = new HistoricVariableInstanceQueryDto();
        if (filter != null) {
            if (StringUtils.isNotBlank((CharSequence)filter.getActivityInstanceId())) {
                queryDto.activityInstanceIdIn(List.of(filter.getActivityInstanceId()));
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getProcessInstanceId())) {
                queryDto.processInstanceId(filter.getProcessInstanceId());
            }
        }
        return queryDto;
    }

    protected List<HistoricVariableInstanceQueryDtoSortingInner> createHistoricVariableSortOptions(Sort sort) {
        ArrayList<HistoricVariableInstanceQueryDtoSortingInner> sortDtoList = new ArrayList<HistoricVariableInstanceQueryDtoSortingInner>();
        for (Sort.Order order : sort.getOrders()) {
            String property = order.getProperty();
            HistoricVariableInstanceQueryDtoSortingInner sortDto = new HistoricVariableInstanceQueryDtoSortingInner();
            if (property.equals("name")) {
                sortDto.setSortBy(HistoricVariableInstanceQueryDtoSortingInner.SortByEnum.VARIABLE_NAME);
            }
            if (order.getDirection() == Sort.Direction.ASC) {
                sortDto.setSortOrder(HistoricVariableInstanceQueryDtoSortingInner.SortOrderEnum.ASC);
            } else if (order.getDirection() == Sort.Direction.DESC) {
                sortDto.setSortOrder(HistoricVariableInstanceQueryDtoSortingInner.SortOrderEnum.DESC);
            }
            if (sortDto.getSortBy() == null || sortDto.getSortOrder() == null) continue;
            sortDtoList.add(sortDto);
        }
        return sortDtoList;
    }

    protected VariableInstanceQueryDto createVariableInstanceQuery(@Nullable VariableFilter filter) {
        VariableInstanceQueryDto variableInstanceQueryDto = new VariableInstanceQueryDto();
        if (filter != null) {
            if (StringUtils.isNotBlank((CharSequence)filter.getActivityInstanceId())) {
                variableInstanceQueryDto.activityInstanceIdIn(List.of(filter.getActivityInstanceId()));
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getProcessInstanceId())) {
                variableInstanceQueryDto.addProcessInstanceIdInItem(filter.getProcessInstanceId());
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getVariableName())) {
                variableInstanceQueryDto.setVariableName(filter.getVariableName());
            }
        }
        return variableInstanceQueryDto;
    }
}

