/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.control.dto.BpmProcessDefinition;
import io.openbpm.control.dto.DmnDecisionDefinition;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmParseUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(BpmParseUtil.class);

    public static List<BpmProcessDefinition> parseProcessDefinitionsJson(String processDefinitionsJson) {
        try {
            if (StringUtils.isNotBlank((CharSequence)processDefinitionsJson)) {
                return (List)objectMapper.readValue(processDefinitionsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Unable parse definitions JSON {}", (Object)processDefinitionsJson);
        }
        return List.of();
    }

    public static List<DmnDecisionDefinition> parseDecisionsDefinitionsJson(String decisionDefinitionsJson) {
        try {
            if (StringUtils.isNotBlank((CharSequence)decisionDefinitionsJson)) {
                return (List)objectMapper.readValue(decisionDefinitionsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Unable parse definitions JSON {}", (Object)decisionDefinitionsJson);
        }
        return List.of();
    }
}

