/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.decisiondefinition;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.LoadContext;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.codeeditor.CodeEditor;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.tabsheet.JmixTabSheet;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.PrimaryDetailView;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.decisiondefinition.DecisionDefinitionData;
import io.openbpm.control.entity.deployment.DeploymentData;
import io.openbpm.control.service.decisiondefinition.DecisionDefinitionService;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.view.decisioninstance.DecisionInstancesFragment;
import io.openbpm.control.view.deploymentdata.DeploymentDetailView;
import io.openbpm.control.view.event.TitleUpdateEvent;
import io.openbpm.uikit.fragment.dmnviewer.DmnViewerFragment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@Route(value="bpm/decision-definitions/:id", layout=DefaultMainViewParent.class)
@ViewController(id="bpm_DecisionDefinition.detail")
@ViewDescriptor(value="decision-definition-detail-view.xml")
@EditedEntityContainer(value="decisionDefinitionDc")
@DialogMode(width="50em", height="37.5em")
@PrimaryDetailView(value=DecisionDefinitionData.class)
public class DecisionDefinitionDetailView
extends StandardDetailView<DecisionDefinitionData> {
    @Autowired
    private DecisionDefinitionService decisionDefinitionService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private UiComponents uiComponents;
    @Autowired
    private UiEventPublisher uiEventPublisher;
    @Autowired
    private ViewNavigators viewNavigators;
    @ViewComponent
    private InstanceContainer<DecisionDefinitionData> decisionDefinitionDc;
    @ViewComponent
    private JmixComboBox<DecisionDefinitionData> versionComboBox;
    @ViewComponent
    private TypedDateTimePicker<Comparable> deploymentTimeField;
    @ViewComponent
    private TypedTextField<Object> deploymentSourceField;
    @ViewComponent
    private DecisionInstancesFragment decisionInstancesFragment;
    @ViewComponent
    private MessageBundle messageBundle;
    @ViewComponent
    private CodeEditor dmnXmlEditor;
    @ViewComponent
    private DmnViewerFragment viewerFragment;
    @ViewComponent
    private JmixFormLayout decisionDefinitionForm;
    @ViewComponent
    private JmixTabSheet tabSheet;
    @ViewComponent
    private HorizontalLayout detailActions;
    @ViewComponent
    private TypedTextField<Object> deploymentIdField;
    private String title = "";

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"p-0"});
        this.initTabIcons();
        this.decisionDefinitionForm.addClassName("pr-xs");
        this.detailActions.addClassNames(new String[]{"pb-s", "pr-m", "pt-xs"});
    }

    @Subscribe(id="viewDeployment", subject="clickListener")
    public void onViewDeploymentClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.detailView((View)this, DeploymentData.class).withViewClass(DeploymentDetailView.class).withRouteParameters(new RouteParameters("id", ((DecisionDefinitionData)this.getEditedEntity()).getDeploymentId())).withBackwardNavigation(true).navigate();
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        this.sendUpdateViewTitleEvent();
    }

    public String getPageTitle() {
        return this.title;
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.initVersionLookup((DecisionDefinitionData)this.getEditedEntity());
        this.initDeploymentData();
    }

    protected void initTabIcons() {
        this.tabSheet.getTabAt(0).addComponentAsFirst((Component)VaadinIcon.INFO_CIRCLE_O.create());
        this.tabSheet.getTabAt(1).addComponentAsFirst((Component)VaadinIcon.SITEMAP.create());
        this.tabSheet.getTabAt(2).addComponentAsFirst((Component)VaadinIcon.FILE_CODE.create());
    }

    @Install(to="decisionDefinitionDl", target=Target.DATA_LOADER)
    protected DecisionDefinitionData decisionDefinitionDlDelegate(LoadContext<DecisionDefinitionData> loadContext) {
        DecisionDefinitionData item = (DecisionDefinitionData)this.decisionDefinitionDc.getItemOrNull();
        String id = item == null ? Objects.requireNonNull(loadContext.getId()).toString() : item.getId();
        return this.decisionDefinitionService.getById(id);
    }

    @Subscribe(value="versionComboBox")
    protected void onVersionLookupValueChange(AbstractField.ComponentValueChangeEvent<ComboBox<DecisionDefinitionData>, DecisionDefinitionData> event) {
        DecisionDefinitionData selectedProcessDefinition = (DecisionDefinitionData)event.getValue();
        this.decisionDefinitionDc.setItem((Object)selectedProcessDefinition);
        this.decisionInstancesFragment.initInstancesCountLabels();
        this.sendUpdateViewTitleEvent();
        this.initDeploymentData();
    }

    @Subscribe(id="decisionDefinitionDc", target=Target.DATA_CONTAINER)
    protected void onDecisionDefinitionDcItemChange(InstanceContainer.ItemChangeEvent<DecisionDefinitionData> event) {
        DecisionDefinitionData decisionDefinition = (DecisionDefinitionData)event.getItem();
        if (decisionDefinition == null) {
            return;
        }
        String dmnXml = this.decisionDefinitionService.getDmnXml(decisionDefinition.getDecisionDefinitionId());
        this.viewerFragment.initViewer();
        this.viewerFragment.setDmnXml(dmnXml);
        this.dmnXmlEditor.setValue(dmnXml);
        this.sendUpdateViewTitleEvent();
    }

    protected void sendUpdateViewTitleEvent() {
        this.title = this.messageBundle.formatMessage("decisionDefinition.title.name", new Object[]{((DecisionDefinitionData)this.getEditedEntity()).getKey()});
        FlexLayout flexLayout = (FlexLayout)this.uiComponents.create(FlexLayout.class);
        flexLayout.addClassNames(new String[]{"ml-xs", "gap-s"});
        Span version = (Span)this.uiComponents.create(Span.class);
        version.addClassNames(new String[]{"text-secondary", "font-bold"});
        version.setText(this.messageBundle.formatMessage("decisionDefinition.title.version", new Object[]{((DecisionDefinitionData)this.getEditedEntity()).getVersion()}));
        flexLayout.add(new Component[]{version});
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new TitleUpdateEvent((Object)this, this.title, (Component)flexLayout));
    }

    protected void initVersionLookup(DecisionDefinitionData decisionDefinition) {
        List optionsList = this.decisionDefinitionService.findAllByKey(decisionDefinition.getKey());
        this.versionComboBox.setItems((Collection)optionsList);
        this.versionComboBox.setItemLabelGenerator(DecisionDefinitionData::getVersion);
        this.versionComboBox.setValue((Object)decisionDefinition);
    }

    protected void initDeploymentData() {
        DeploymentData deployment = this.deploymentService.findById(((DecisionDefinitionData)this.getEditedEntity()).getDeploymentId());
        if (deployment != null) {
            String source = deployment.getSource();
            this.deploymentIdField.setTypedValue((Object)deployment.getDeploymentId());
            this.deploymentSourceField.setTypedValue((Object)source);
            this.deploymentTimeField.setTypedValue((Comparable)deployment.getDeploymentTime());
        }
    }
}

