/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.deploymentdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.deployment.DeploymentData;
import io.openbpm.control.exception.RemoteProcessEngineException;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/bulkdeletedeployment", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_BulkDeleteDeployment")
@ViewDescriptor(value="bulk-delete-deployment-view.xml")
@DialogMode(width="35em")
public class BulkDeleteDeploymentView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkDeleteDeploymentView.class);
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected DeploymentService deploymentService;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected JmixCheckbox deleteProcessInstancesCheckBox;
    @ViewComponent
    protected Icon allInstancesContextHelp;
    @ViewComponent
    protected JmixCheckbox skipCustomListenersCheckBox;
    @ViewComponent
    protected JmixCheckbox skipIOMappingsCheckBox;
    protected Collection<DeploymentData> deployments;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.onInit();
    }

    public void setDeployments(Collection<DeploymentData> deployments) {
        this.deployments = deployments;
    }

    protected void onInit() {
        this.addClassNames(new String[]{"pt-0", "pl-l"});
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(false));
        boolean hasRunningInstances = false;
        for (DeploymentData deploymentData : this.deployments) {
            long countByDeploymentId = this.processInstanceService.getCountByDeploymentId(deploymentData.getDeploymentId());
            if (countByDeploymentId <= 0L) continue;
            hasRunningInstances = true;
            break;
        }
        if (hasRunningInstances) {
            this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(true));
            this.allInstancesContextHelp.setTooltipText(this.messageBundle.getMessage("bulkDeleteAllRunningInstances.tooltip"));
        }
        this.deleteProcessInstancesCheckBox.setEnabled(!hasRunningInstances);
    }

    @Subscribe(value="okBtn")
    protected void onOkBtnClick(ClickEvent<Button> event) {
        boolean deleteAllRelatedInstances = BooleanUtils.isTrue((Boolean)((Boolean)this.deleteProcessInstancesCheckBox.getValue()));
        boolean skipCustomListeners = BooleanUtils.isTrue((Boolean)((Boolean)this.skipCustomListenersCheckBox.getValue()));
        boolean skipIOMappings = BooleanUtils.isTrue((Boolean)((Boolean)this.skipIOMappingsCheckBox.getValue()));
        try {
            for (DeploymentData deploymentData : this.deployments) {
                this.deploymentService.deleteById(deploymentData.getId(), deleteAllRelatedInstances, skipCustomListeners, skipIOMappings);
            }
            this.notifications.create(this.messageBundle.getMessage("deploymentsDeleted")).withType(Notifications.Type.SUCCESS).show();
        }
        catch (Exception e) {
            if (e instanceof RemoteProcessEngineException) {
                RemoteProcessEngineException processEngineException = (RemoteProcessEngineException)((Object)e);
                log.error("Unable to delete deployments", (Throwable)e);
                String responseMessage = processEngineException.getResponseMessage();
                String errorReason = StringUtils.isNotEmpty((CharSequence)responseMessage) ? responseMessage.replaceAll("\\.", ".\n") : e.getMessage();
                this.notifications.create(errorReason).withType(Notifications.Type.ERROR).withDuration(10000).show();
                return;
            }
            throw e;
        }
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

