/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.incidentdata;

import com.google.common.base.Strings;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLink;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.service.externaltask.ExternalTaskService;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.service.job.JobService;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.view.event.TitleUpdateEvent;
import io.openbpm.control.view.externaltask.ExternalTaskErrorDetailsView;
import io.openbpm.control.view.incidentdata.RetryExternalTaskView;
import io.openbpm.control.view.incidentdata.RetryJobView;
import io.openbpm.control.view.job.JobErrorDetailsView;
import io.openbpm.control.view.main.MainView;
import io.openbpm.control.view.processdefinition.ProcessDefinitionDetailView;
import io.openbpm.control.view.processinstance.ProcessInstanceDetailView;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.Nullable;

@Route(value="bpm/incident/:id", layout=MainView.class)
@ViewController(value="IncidentData.detail")
@ViewDescriptor(value="incident-data-detail-view.xml")
@EditedEntityContainer(value="incidentDataDc")
@DialogMode(minWidth="40em", width="80%", maxWidth="75em")
public class IncidentDataDetailView
extends StandardDetailView<IncidentData> {
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected Messages messages;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected IncidentService incidentService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    protected JobService jobService;
    @ViewComponent
    protected JmixButton viewStacktraceBtn;
    @ViewComponent
    protected TypedTextField<String> configurationField;
    @ViewComponent
    protected TypedTextField<String> incidentIdField;
    @ViewComponent
    protected JmixButton copyConfigurationBtn;
    @ViewComponent
    protected JmixButton viewCauseIncidentBtn;
    @ViewComponent
    protected JmixButton viewRootCauseIncidentBtn;
    @ViewComponent
    protected TypedTextField<Object> causeIncidentIdField;
    @ViewComponent
    protected TypedTextField<Object> rootCauseIncidentIdField;
    @ViewComponent
    protected JmixButton retryBtn;
    @ViewComponent
    protected TypedTextField<String> processDefinitionIdField;
    @ViewComponent
    protected HorizontalLayout detailActions;
    protected String title;
    @Autowired
    protected ExternalTaskService externalTaskService;
    @ViewComponent
    protected JmixButton viewProcessBtn;
    @ViewComponent
    protected JmixButton viewProcessInstanceBtn;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.title = this.messageBundle.getMessage("incidentDetails.title");
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        boolean openInDialog = this.isOpenInDialog();
        if (!openInDialog) {
            this.sendUpdateViewTitleEvent();
        }
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        boolean openInDialog = this.isOpenInDialog();
        if (openInDialog) {
            this.addClassNames(new String[]{"pt-xs", "pb-l"});
        } else {
            this.detailActions.addClassNames(new String[]{"sticky-buttons-bottom-panel"});
        }
        this.initIncidentTypeRelatedFields();
        this.initProcessFields();
        this.initCauseIncidentFields();
        this.initRootCauseIncidentFields();
    }

    @Subscribe(id="viewProcessBtn", subject="clickListener")
    public void onViewProcessBtnClick(ClickEvent<JmixButton> event) {
        this.openView(ProcessDefinitionDetailView.class, new RouteParameters("id", ((IncidentData)this.getEditedEntity()).getProcessDefinitionId()));
    }

    @Subscribe(id="viewCauseIncidentBtn", subject="clickListener")
    public void onViewCauseIncidentBtnClick(ClickEvent<JmixButton> event) {
        this.openView(IncidentDataDetailView.class, new RouteParameters("id", ((IncidentData)this.getEditedEntity()).getCauseIncidentId()));
    }

    @Subscribe(id="viewRootCauseIncidentBtn", subject="clickListener")
    public void onViewRootCauseIncidentBtnClick(ClickEvent<JmixButton> event) {
        this.openView(IncidentDataDetailView.class, new RouteParameters("id", ((IncidentData)this.getEditedEntity()).getRootCauseIncidentId()));
    }

    @Subscribe(id="viewProcessInstanceBtn", subject="clickListener")
    public void onViewProcessInstanceBtnClick(ClickEvent<JmixButton> event) {
        this.openView(ProcessInstanceDetailView.class, new RouteParameters("id", ((IncidentData)this.getEditedEntity()).getProcessInstanceId()));
    }

    @Subscribe(id="viewStacktraceBtn", subject="clickListener")
    public void onViewStacktraceBtnClick(ClickEvent<JmixButton> event) {
        if (((IncidentData)this.getEditedEntity()).isJobFailed()) {
            this.dialogWindows.view((View)this, JobErrorDetailsView.class).withViewConfigurer(view -> view.setJobId(((IncidentData)this.getEditedEntity()).getConfiguration())).build().open();
        } else if (((IncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            this.dialogWindows.view((View)this, ExternalTaskErrorDetailsView.class).withViewConfigurer(view -> view.setExternalTaskId(((IncidentData)this.getEditedEntity()).getConfiguration())).build().open();
        }
    }

    @Install(to="incidentDataDl", target=Target.DATA_LOADER)
    protected IncidentData incidentDataDlLoadDelegate(LoadContext<IncidentData> loadContext) {
        Object id = loadContext.getId();
        if (id != null) {
            return this.incidentService.findRuntimeIncidentById(id.toString());
        }
        return null;
    }

    @Subscribe(id="copyIdBtn", subject="clickListener")
    public void onCopyIdBtnClick(ClickEvent<JmixButton> event) {
        Element buttonElement = ((JmixButton)event.getSource()).getElement();
        String valueToCopy = Strings.nullToEmpty((String)((String)this.incidentIdField.getTypedValue()));
        buttonElement.executeJs("  const textarea = document.createElement(\"textarea\");\n  textarea.value = $0;\n\n  textarea.style.position = \"absolute\";\n  textarea.style.opacity = \"0\";\n\n  document.body.appendChild(textarea);\n  textarea.select();\n  document.execCommand(\"copy\");\n  document.body.removeChild(textarea);\n", new Serializable[]{valueToCopy}).then((SerializableConsumer & Serializable)successResult -> this.notifications.create(this.messageBundle.getMessage("incidentIdCopied")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_SUCCESS).show(), (SerializableConsumer & Serializable)errorResult -> this.notifications.create(this.messageBundle.getMessage("incidentIdCopyFailed")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_ERROR).show());
    }

    @Subscribe(id="copyConfigurationBtn", subject="clickListener")
    public void onCopyConfigurationBtnClick(ClickEvent<JmixButton> event) {
        String valueCopyFailedMsg;
        String valueCopiedMsg;
        if (((IncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            valueCopiedMsg = "externalTaskIdCopied";
            valueCopyFailedMsg = "externalTaskIdCopyFailed";
        } else if (((IncidentData)this.getEditedEntity()).isJobFailed()) {
            valueCopiedMsg = "jobIdCopied";
            valueCopyFailedMsg = "jobIdCopyFailed";
        } else {
            valueCopiedMsg = "payloadCopied";
            valueCopyFailedMsg = "payloadCopyFailed";
        }
        Element buttonElement = ((JmixButton)event.getSource()).getElement();
        String valueToCopy = Strings.nullToEmpty((String)((String)this.configurationField.getTypedValue()));
        buttonElement.executeJs("  const textarea = document.createElement(\"textarea\");\n  textarea.value = $0;\n\n  textarea.style.position = \"absolute\";\n  textarea.style.opacity = \"0\";\n\n  document.body.appendChild(textarea);\n  textarea.select();\n  document.execCommand(\"copy\");\n  document.body.removeChild(textarea);\n", new Serializable[]{valueToCopy}).then((SerializableConsumer & Serializable)successResult -> this.notifications.create(this.messageBundle.getMessage(valueCopiedMsg)).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_SUCCESS).show(), (SerializableConsumer & Serializable)errorResult -> this.notifications.create(this.messageBundle.getMessage(valueCopyFailedMsg)).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_ERROR).show());
    }

    @Subscribe(id="retryBtn", subject="clickListener")
    public void onRetryBtnClick(ClickEvent<JmixButton> event) {
        if (((IncidentData)this.getEditedEntity()).isJobFailed()) {
            DialogWindow dialogWindow = this.dialogWindows.view((View)this, RetryJobView.class).withAfterCloseListener(afterClose -> {
                if (afterClose.closedWith(StandardOutcome.SAVE)) {
                    this.close(StandardOutcome.SAVE);
                }
            }).build();
            RetryJobView retryRuntimeJobView = (RetryJobView)dialogWindow.getView();
            retryRuntimeJobView.setJobId(((IncidentData)this.getEditedEntity()).getConfiguration());
            dialogWindow.open();
        } else if (((IncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            DialogWindow dialogWindow = this.dialogWindows.view((View)this, RetryExternalTaskView.class).withAfterCloseListener(closeEvent -> {
                if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                    this.close(StandardOutcome.SAVE);
                }
            }).build();
            RetryExternalTaskView retryExternalTaskView = (RetryExternalTaskView)dialogWindow.getView();
            retryExternalTaskView.setExternalTaskId(((IncidentData)this.getEditedEntity()).getConfiguration());
            dialogWindow.open();
        }
    }

    protected void sendUpdateViewTitleEvent() {
        String baseTitle = this.messageBundle.getMessage("incidentDataDetailView.baseTitle");
        this.title = this.messageBundle.formatMessage("incidentDataDetailView.title", new Object[]{((IncidentData)this.getEditedEntity()).getIncidentId()});
        FlexLayout flexLayout = (FlexLayout)this.uiComponents.create(FlexLayout.class);
        flexLayout.addClassNames(new String[]{"ml-xs", "gap-s"});
        flexLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        H5 instanceId = (H5)this.uiComponents.create(H5.class);
        instanceId.setHeightFull();
        instanceId.setText("\"" + ((IncidentData)this.getEditedEntity()).getIncidentId() + "\"");
        instanceId.addClassNames(new String[]{"text-body"});
        flexLayout.add(new Component[]{instanceId});
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new TitleUpdateEvent((Object)this, baseTitle, (Component)flexLayout));
    }

    public String getPageTitle() {
        return this.title;
    }

    protected boolean isOpenInDialog() {
        return this.findAncestor(Dialog.class) != null;
    }

    public boolean hasUnsavedChanges() {
        return false;
    }

    protected void openView(Class<? extends StandardView> viewClass, RouteParameters routeParameters) {
        if (!this.isOpenInDialog()) {
            this.viewNavigators.view((View)this, viewClass).withRouteParameters(routeParameters).withBackwardNavigation(false).navigate();
        } else {
            RouterLink routerLink = new RouterLink(viewClass, routeParameters);
            this.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
        }
    }

    protected void initIncidentTypeRelatedFields() {
        boolean notEmptyPayload;
        boolean bl = notEmptyPayload = ((IncidentData)this.getEditedEntity()).getConfiguration() != null;
        if (((IncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            this.viewStacktraceBtn.setVisible(notEmptyPayload);
            this.copyConfigurationBtn.setVisible(notEmptyPayload);
            this.configurationField.setLabel(this.messageBundle.getMessage("externalTaskIdLabel"));
        } else if (((IncidentData)this.getEditedEntity()).isJobFailed()) {
            this.configurationField.setLabel(this.messageBundle.getMessage("jobIdLabel"));
            this.copyConfigurationBtn.setVisible(notEmptyPayload);
            this.viewStacktraceBtn.setVisible(notEmptyPayload);
        } else {
            this.viewStacktraceBtn.setVisible(false);
        }
    }

    protected void initRootCauseIncidentFields() {
        String rootCauseIncidentLabel;
        String rootCauseIncidentId = ((IncidentData)this.getEditedEntity()).getRootCauseIncidentId();
        boolean isRootCauseIncident = StringUtils.equals((CharSequence)((IncidentData)this.getEditedEntity()).getIncidentId(), (CharSequence)((IncidentData)this.getEditedEntity()).getRootCauseIncidentId());
        this.retryBtn.setVisible(isRootCauseIncident && ((IncidentData)this.getEditedEntity()).isJobFailed() || ((IncidentData)this.getEditedEntity()).isExternalTaskFailed());
        if (isRootCauseIncident) {
            this.viewRootCauseIncidentBtn.setVisible(false);
            String processLabel = ((IncidentData)this.getEditedEntity()).getProcessDefinitionId() != null ? (String)this.processDefinitionIdField.getTypedValue() : this.messageBundle.getMessage("withoutProcessLabel");
            rootCauseIncidentLabel = this.messageBundle.formatMessage("incidentWithProcess", new Object[]{rootCauseIncidentId, processLabel});
        } else {
            rootCauseIncidentLabel = this.getRelatedIncidentFieldLabel(rootCauseIncidentId);
        }
        this.rootCauseIncidentIdField.setValue(rootCauseIncidentLabel);
    }

    protected void initCauseIncidentFields() {
        String causeIncidentLabel;
        String causeIncidentId = ((IncidentData)this.getEditedEntity()).getCauseIncidentId();
        if (StringUtils.equals((CharSequence)((IncidentData)this.getEditedEntity()).getIncidentId(), (CharSequence)causeIncidentId)) {
            this.viewCauseIncidentBtn.setVisible(false);
            String relatedProcess = ((IncidentData)this.getEditedEntity()).getProcessDefinitionId() != null ? (String)this.processDefinitionIdField.getTypedValue() : this.messageBundle.getMessage("withoutProcessLabel");
            causeIncidentLabel = this.messageBundle.formatMessage("incidentWithProcess", new Object[]{causeIncidentId, relatedProcess});
        } else {
            causeIncidentLabel = this.getRelatedIncidentFieldLabel(causeIncidentId);
        }
        this.causeIncidentIdField.setValue(causeIncidentLabel);
    }

    protected void initProcessFields() {
        String processLabel = this.getProcessLabel((IncidentData)this.getEditedEntity());
        this.processDefinitionIdField.setTypedValue((Object)processLabel);
        this.viewProcessBtn.setVisible(((IncidentData)this.getEditedEntity()).getProcessDefinitionId() != null);
        this.viewProcessInstanceBtn.setVisible(((IncidentData)this.getEditedEntity()).getProcessInstanceId() != null);
    }

    protected String getRelatedIncidentFieldLabel(String relatedIncidentId) {
        String relatedIncidentLabel;
        IncidentData relatedIncident = this.incidentService.findRuntimeIncidentById(relatedIncidentId);
        if (relatedIncident != null) {
            String processLabel = relatedIncident.getProcessDefinitionId() != null ? this.getProcessLabel(relatedIncident) : this.messageBundle.getMessage("withoutProcessLabel");
            relatedIncidentLabel = this.messageBundle.formatMessage("incidentWithProcess", new Object[]{relatedIncidentId, processLabel});
        } else {
            relatedIncidentLabel = relatedIncidentId;
        }
        return relatedIncidentLabel;
    }

    @Nullable
    protected String getProcessLabel(IncidentData incident) {
        if (incident.getProcessDefinitionId() == null) {
            return null;
        }
        ProcessDefinitionData process = this.processDefinitionService.getById(incident.getProcessDefinitionId());
        return Optional.ofNullable(process).map(ProcessDefinitionData::getKey).orElse(null);
    }
}

