/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.incidentdata.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.textfield.TextField;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import io.openbpm.control.entity.filter.IncidentFilter;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.view.incidentdata.IncidentHeaderFilter;
import org.apache.commons.lang3.StringUtils;

public class MessageHeaderFilter
extends IncidentHeaderFilter {
    protected TextField messageField;

    public MessageHeaderFilter(Grid<IncidentData> dataGrid, DataGridColumn<IncidentData> column, InstanceContainer<IncidentFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        return this.createMessageFilter();
    }

    protected void resetFilterValues() {
        this.messageField.clear();
    }

    public void apply() {
        String value = this.messageField.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        ((IncidentFilter)this.filterDc.getItem()).setIncidentMessageLike(value);
        this.filterButton.getElement().setAttribute("activated", value != null);
    }

    protected TextField createMessageFilter() {
        this.messageField = (TextField)this.uiComponents.create(TextField.class);
        this.messageField.setWidthFull();
        this.messageField.setMinWidth("30em");
        this.messageField.setClearButtonVisible(true);
        this.messageField.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.incidentMessageLike"));
        this.messageField.setPlaceholder(this.messages.getMessage(this.getClass(), "incidentMessage.placeholder"));
        return this.messageField;
    }
}

