/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.incidentdata.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.textfield.TextField;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import io.micrometer.common.util.StringUtils;
import io.openbpm.control.entity.filter.IncidentFilter;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.view.incidentdata.IncidentHeaderFilter;

public class ProcessInstanceIdHeaderFilter
extends IncidentHeaderFilter {
    protected TextField processInstanceIdField;

    public ProcessInstanceIdHeaderFilter(Grid<IncidentData> dataGrid, DataGridColumn<IncidentData> column, InstanceContainer<IncidentFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        return this.createProcessInstanceIdFilter();
    }

    protected void resetFilterValues() {
        this.processInstanceIdField.clear();
    }

    public void apply() {
        String value = this.processInstanceIdField.getValue();
        boolean notEmptyValue = StringUtils.isNotEmpty((String)value);
        if (notEmptyValue) {
            ((IncidentFilter)this.filterDc.getItem()).setProcessInstanceId(value);
        } else {
            ((IncidentFilter)this.filterDc.getItem()).setProcessInstanceId(null);
        }
        this.filterButton.getElement().setAttribute("activated", notEmptyValue);
    }

    protected TextField createProcessInstanceIdFilter() {
        this.processInstanceIdField = (TextField)this.uiComponents.create(TextField.class);
        this.processInstanceIdField.setWidthFull();
        this.processInstanceIdField.setMinWidth("30em");
        this.processInstanceIdField.setClearButtonVisible(true);
        this.processInstanceIdField.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.processInstanceId"));
        this.processInstanceIdField.setPlaceholder(this.messages.getMessage(this.getClass(), "processInstanceId.placeholder"));
        return this.processInstanceIdField;
    }
}

