/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.DataLoader;
import io.jmix.flowui.model.HasLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.action.CopyComponentValueToClipboardAction;
import io.openbpm.control.entity.deployment.DeploymentData;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.view.deploymentdata.DeploymentDetailView;
import io.openbpm.control.view.processdefinition.ActivateProcessDefinitionView;
import io.openbpm.control.view.processdefinition.DeleteProcessDefinitionView;
import io.openbpm.control.view.processdefinition.ProcessDefinitionDetailView;
import io.openbpm.control.view.processdefinition.SuspendProcessDefinitionView;
import io.openbpm.control.view.processdefinition.event.ReloadSelectedProcess;
import io.openbpm.control.view.processinstancemigration.ProcessInstanceMigrationView;
import io.openbpm.control.view.startprocess.StartProcessWithVariableView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="general-panel-fragment.xml")
public class GeneralPanelFragment
extends Fragment<FlexLayout> {
    @ViewComponent
    protected VerticalLayout upperPanel;
    @ViewComponent
    protected JmixButton infoBtn;
    @ViewComponent
    protected JmixFormLayout processDefinitionForm;
    @ViewComponent
    protected InstanceContainer<ProcessDefinitionData> processDefinitionDataDc;
    @ViewComponent
    protected JmixButton activateBtn;
    @ViewComponent
    protected JmixButton suspendBtn;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected TypedTextField<String> keyField;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected TypedTextField<String> idField;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected DeploymentService deploymentService;
    @ViewComponent
    protected TypedTextField<Object> deploymentIdField;
    @ViewComponent
    protected TypedTextField<Object> deploymentSourceField;
    @ViewComponent
    protected TypedDateTimePicker<Comparable> deploymentTimeField;
    @ViewComponent
    protected JmixButton startProcessBtn;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected CollectionContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected CopyComponentValueToClipboardAction copyIdAction;
    @ViewComponent
    protected CopyComponentValueToClipboardAction copyKeyAction;
    @Autowired
    protected UiEventPublisher uiEventPublisher;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.processDefinitionForm.getComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe(target=Target.HOST_CONTROLLER)
    public void onHostBeforeShow(View.BeforeShowEvent event) {
        this.initActionButtons();
        this.copyIdAction.setTarget((HasValue)this.idField);
        this.copyKeyAction.setTarget((HasValue)this.keyField);
        this.infoBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
    }

    public void refresh() {
        this.initActionButtons();
        this.initDeploymentData();
    }

    @Subscribe(value="infoBtn")
    protected void onInfoButtonClickBtnClick(ClickEvent<Button> event) {
        boolean active = this.upperPanel.hasClassName("active");
        if (active) {
            this.upperPanel.removeClassName("active");
        } else {
            this.upperPanel.addClassName("active");
        }
        if (this.upperPanel.hasClassName("active")) {
            this.infoBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.infoBtn.setTitle(this.messageBundle.getMessage("hideProcessInformation.title"));
        } else {
            this.infoBtn.removeThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.infoBtn.setTitle(this.messageBundle.getMessage("viewProcessInformation.title"));
        }
    }

    @Subscribe(id="viewDeployment", subject="clickListener")
    public void onViewDeploymentClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), DeploymentData.class).withViewClass(DeploymentDetailView.class).withRouteParameters(new RouteParameters("id", ((ProcessDefinitionData)this.processDefinitionDataDc.getItem()).getDeploymentId())).withBackwardNavigation(true).navigate();
    }

    @Subscribe(id="startProcessBtn", subject="clickListener")
    public void onStartProcessBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), ProcessDefinitionData.class).withViewClass(StartProcessWithVariableView.class).editEntity((Object)((ProcessDefinitionData)this.processDefinitionDataDc.getItem())).withAfterCloseListener(e -> {
            if (e.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessInstances();
                this.notifications.create(this.messages.formatMessage(ProcessDefinitionDetailView.class, "startProcess.success", new Object[]{((ProcessDefinitionData)((StartProcessWithVariableView)e.getView()).getEditedEntity()).getProcessDefinitionId()})).withType(Notifications.Type.SUCCESS).build().open();
            }
        }).open();
    }

    @Subscribe(id="migrateBtn", subject="clickListener")
    protected void onMigrateBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), ProcessInstanceMigrationView.class).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessInstances();
                this.notifications.create(this.messageBundle.getMessage("processInstancesMigrationStarted")).withType(Notifications.Type.SUCCESS).show();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionData((ProcessDefinitionData)this.processDefinitionDataDc.getItem())).build().open();
    }

    @Subscribe(id="suspendBtn", subject="clickListener")
    protected void onSuspendBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), SuspendProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessDefinition();
                this.initActionButtons();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(((ProcessDefinitionData)this.processDefinitionDataDc.getItem()).getId())).build().open();
    }

    @Subscribe(id="deleteBtn", subject="clickListener")
    protected void onDeleteBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), DeleteProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                UiComponentUtils.getCurrentView().close(ProcessDefinitionDetailView.REMOVE_PROCESS_DEFINITION_CLOSE_ACTION);
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(((ProcessDefinitionData)this.processDefinitionDataDc.getItem()).getId())).build().open();
    }

    @Subscribe(id="activateBtn", subject="clickListener")
    protected void onActivateBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), ActivateProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessDefinition();
                this.initActionButtons();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(((ProcessDefinitionData)this.processDefinitionDataDc.getItem()).getId())).build().open();
    }

    protected void reloadProcessInstances() {
        HasLoader container;
        DataLoader loader;
        CollectionContainer collectionContainer = this.processInstanceDataDc;
        if (collectionContainer instanceof HasLoader && (loader = (container = (HasLoader)collectionContainer).getLoader()) != null) {
            loader.load();
        }
    }

    protected void initDeploymentData() {
        DeploymentData deployment = this.deploymentService.findById(((ProcessDefinitionData)this.processDefinitionDataDc.getItem()).getDeploymentId());
        if (deployment != null) {
            this.deploymentIdField.setTypedValue((Object)deployment.getDeploymentId());
            this.deploymentSourceField.setTypedValue((Object)deployment.getSource());
            this.deploymentTimeField.setTypedValue((Comparable)deployment.getDeploymentTime());
        }
    }

    protected void initActionButtons() {
        ProcessDefinitionData item = (ProcessDefinitionData)this.processDefinitionDataDc.getItem();
        boolean suspended = Boolean.TRUE.equals(item.getSuspended());
        this.activateBtn.setVisible(suspended);
        this.suspendBtn.setVisible(!suspended);
        this.startProcessBtn.setVisible(!suspended);
    }

    protected void reloadProcessDefinition() {
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new ReloadSelectedProcess((Object)this));
    }
}

