/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.router.Route;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.core.Sort;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.codeeditor.CodeEditor;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.DataLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.CloseAction;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.PrimaryDetailView;
import io.jmix.flowui.view.StandardCloseAction;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.dashboard.IncidentStatistics;
import io.openbpm.control.entity.filter.ProcessDefinitionFilter;
import io.openbpm.control.entity.filter.ProcessInstanceFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.entity.processinstance.RuntimeProcessInstanceData;
import io.openbpm.control.service.activity.ActivityService;
import io.openbpm.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.service.processinstance.ProcessInstanceLoadContext;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import io.openbpm.control.uicomponent.viewer.handler.CallActivityOverlayClickHandler;
import io.openbpm.control.view.event.TitleUpdateEvent;
import io.openbpm.control.view.processdefinition.GeneralPanelFragment;
import io.openbpm.control.view.processdefinition.ProcessInstancesFragment;
import io.openbpm.control.view.processdefinition.event.ReloadSelectedProcess;
import io.openbpm.control.view.processdefinition.event.ResetActivityEvent;
import io.openbpm.uikit.component.bpmnviewer.ViewerMode;
import io.openbpm.uikit.component.bpmnviewer.command.AddMarkerCmd;
import io.openbpm.uikit.component.bpmnviewer.command.ElementMarkerType;
import io.openbpm.uikit.component.bpmnviewer.command.RemoveMarkerCmd;
import io.openbpm.uikit.component.bpmnviewer.command.SetActivityStatisticsCmd;
import io.openbpm.uikit.component.bpmnviewer.event.ElementClickEvent;
import io.openbpm.uikit.fragment.bpmnviewer.BpmnViewerFragment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;

@Route(value="bpm/process-definitions/:id", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_ProcessDefinition.detail")
@ViewDescriptor(value="process-definition-detail-view.xml")
@EditedEntityContainer(value="processDefinitionDataDc")
@DialogMode(width="50em", height="37.5em")
@PrimaryDetailView(value=ProcessDefinitionData.class)
public class ProcessDefinitionDetailView
extends StandardDetailView<ProcessDefinitionData> {
    public static final CloseAction REMOVE_PROCESS_DEFINITION_CLOSE_ACTION = new StandardCloseAction("removeProcessDefinition");
    protected String title = "";
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected CallActivityOverlayClickHandler callActivityClickHandler;
    @ViewComponent
    protected InstanceContainer<ProcessDefinitionData> processDefinitionDataDc;
    @ViewComponent
    protected DataLoader processDefinitionDataDl;
    @ViewComponent
    protected CollectionContainer<RuntimeProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected CollectionLoader<RuntimeProcessInstanceData> processInstanceDataDl;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceFilter> processInstanceFilterDc;
    @ViewComponent
    protected ComboBox<ProcessDefinitionData> versionComboBox;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    protected ActivityService activityService;
    @ViewComponent
    protected ProcessInstancesFragment processInstancesFragment;
    @ViewComponent
    protected BpmnViewerFragment viewerFragment;
    @ViewComponent
    protected CodeEditor bpmnXmlEditor;
    @ViewComponent
    protected Span allVersionsInstancesCountSpan;
    @ViewComponent
    protected GeneralPanelFragment generalPanel;
    @ViewComponent(value="tabsheet.processInstancesTab")
    protected Tab tabsheetProcessInstancesTab;
    @ViewComponent(value="tabsheet.bpmnXmlTab")
    protected Tab tabsheetBpmnXmlTab;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-0"});
        this.initTabIcons();
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.initProcessInstanceFilter();
        this.processDefinitionDataDl.load();
        this.initVersionLookup((ProcessDefinitionData)this.getEditedEntity());
        this.updateAllRunningInstancesCount();
        this.viewerFragment.showStatisticsButton(true);
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        this.sendUpdateViewTitleEvent();
    }

    public String getPageTitle() {
        return this.title;
    }

    protected void sendUpdateViewTitleEvent() {
        this.title = this.messageBundle.formatMessage("processDefinitionDetail.processName", new Object[]{((ProcessDefinitionData)this.getEditedEntity()).getKey()});
        FlexLayout flexLayout = (FlexLayout)this.uiComponents.create(FlexLayout.class);
        flexLayout.addClassNames(new String[]{"ml-xs", "gap-s"});
        Span version = (Span)this.uiComponents.create(Span.class);
        version.addClassNames(new String[]{"text-secondary", "font-bold"});
        version.setText(this.messageBundle.formatMessage("processDefinitionDetail.processVersion", new Object[]{((ProcessDefinitionData)this.getEditedEntity()).getVersion()}));
        boolean active = BooleanUtils.isNotTrue((Boolean)((ProcessDefinitionData)this.getEditedEntity()).getSuspended());
        String text = active ? this.messageBundle.getMessage("active") : this.messageBundle.getMessage("suspended");
        Span badge = this.createStateBadge(active, text);
        flexLayout.add(new Component[]{version, badge});
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new TitleUpdateEvent((Object)this, this.title, (Component)flexLayout));
    }

    protected void initTabIcons() {
        this.tabsheetProcessInstancesTab.addComponentAsFirst((Component)VaadinIcon.TASKS.create());
        this.tabsheetBpmnXmlTab.addComponentAsFirst((Component)VaadinIcon.FILE_CODE.create());
    }

    @Subscribe(value="versionComboBox")
    protected void onVersionLookupValueChange(AbstractField.ComponentValueChangeEvent<ComboBox<ProcessDefinitionData>, ProcessDefinitionData> event) {
        if (event.isFromClient()) {
            ProcessDefinitionData selectedProcessDefinition = (ProcessDefinitionData)event.getValue();
            this.processDefinitionDataDc.setItem((Object)selectedProcessDefinition);
        }
    }

    @Subscribe(id="processDefinitionDataDc", target=Target.DATA_CONTAINER)
    protected void onProcessDefinitionDcItemChange(InstanceContainer.ItemChangeEvent<ProcessDefinitionData> event) {
        ProcessDefinitionData processDefinition = (ProcessDefinitionData)event.getItem();
        if (processDefinition != null) {
            String bpmnXml = this.processDefinitionService.getBpmnXml(processDefinition.getProcessDefinitionId());
            this.generalPanel.refresh();
            this.initViewer(bpmnXml);
            this.bpmnXmlEditor.setValue(bpmnXml);
            ((ProcessInstanceFilter)this.processInstanceFilterDc.getItem()).setProcessDefinitionId(processDefinition.getProcessDefinitionId());
            this.sendUpdateViewTitleEvent();
        }
    }

    @Install(to="processInstanceDataDl", target=Target.DATA_LOADER)
    protected List<RuntimeProcessInstanceData> processInstanceDataDlLoadDelegate(LoadContext<RuntimeProcessInstanceData> loadContext) {
        ProcessInstanceFilter filter = (ProcessInstanceFilter)this.processInstanceFilterDc.getItem();
        ProcessInstanceLoadContext context = new ProcessInstanceLoadContext().setFilter(filter).setLoadIncidents(true);
        LoadContext.Query query = loadContext.getQuery();
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.processInstanceService.findAllRuntimeInstances(context);
    }

    @Install(to="processDefinitionDataDl", target=Target.DATA_LOADER)
    protected ProcessDefinitionData loadProcessDefinition(LoadContext<ProcessDefinitionData> loadContext) {
        String id = Objects.requireNonNull(loadContext.getId()).toString();
        return this.processDefinitionService.getById(id);
    }

    @Subscribe(id="processInstanceFilterDc", target=Target.DATA_CONTAINER)
    protected void onProcessInstanceFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<ProcessInstanceFilter> event) {
        if (event.getProperty().equals("activeActivityIdIn") || event.getProperty().equals("processDefinitionId")) {
            this.updateCurrentVersionInstancesCount((ProcessInstanceFilter)event.getItem());
            this.processInstanceDataDl.load();
        }
    }

    @EventListener
    public void handleResetActivity(ResetActivityEvent resetActivityEvent) {
        String activityId = resetActivityEvent.getActivityId();
        this.viewerFragment.removeMarker(new RemoveMarkerCmd(activityId, ElementMarkerType.PRIMARY_COLOR_ACTIVITY));
        ((ProcessInstanceFilter)this.processInstanceFilterDc.getItem()).setActiveActivityIdIn(null);
    }

    @EventListener
    public void handleReloadSelectedProcess(ReloadSelectedProcess reloadSelectedProcess) {
        ProcessDefinitionData item = (ProcessDefinitionData)this.processDefinitionDataDc.getItem();
        ProcessDefinitionData reloaded = this.processDefinitionService.getById(item.getId());
        this.processDefinitionDataDc.setItem((Object)reloaded);
        this.updateCurrentVersionInstancesCount((ProcessInstanceFilter)this.processInstanceFilterDc.getItem());
        this.processInstanceDataDl.load();
    }

    protected void initViewer(String bpmnXml) {
        this.viewerFragment.initViewer(bpmnXml);
        this.viewerFragment.showCalledProcessOverlays();
        this.viewerFragment.addCalledProcessOverlayClickListener((ComponentEventListener & Serializable)callActivityOverlayClickEvent -> this.callActivityClickHandler.handleProcessNavigation((ProcessDefinitionData)this.processDefinitionDataDc.getItem(), callActivityOverlayClickEvent.getCallActivity(), UiComponentUtils.isComponentAttachedToDialog((Component)this)));
        this.showStatistics();
    }

    protected void showStatistics() {
        List processStatistics = this.activityService.getStatisticsByProcessId(((ProcessDefinitionData)this.getEditedEntity()).getProcessDefinitionId());
        ArrayList activeElements = new ArrayList();
        processStatistics.forEach(activityStatistics -> {
            Optional<Integer> totalIncidentCount = CollectionUtils.emptyIfNull((Collection)activityStatistics.getIncidents()).stream().map(IncidentStatistics::getIncidentCount).filter(Objects::nonNull).reduce(Integer::sum);
            SetActivityStatisticsCmd cmd = new SetActivityStatisticsCmd(activityStatistics.getActivityId());
            cmd.setIncidentCount((Integer)totalIncidentCount.orElse(null));
            cmd.setInstanceCount(activityStatistics.getInstanceCount());
            this.viewerFragment.setActivityStatistics(cmd);
            activeElements.add(activityStatistics.getActivityId());
        });
        this.viewerFragment.setMode(ViewerMode.INTERACTIVE);
        this.viewerFragment.setActiveElements(activeElements);
        this.viewerFragment.addElementClickListener(arg_0 -> this.handleDiagramElementClick(arg_0));
    }

    protected void handleDiagramElementClick(ElementClickEvent elementClickEvent) {
        ProcessInstanceFilter instanceFilter = (ProcessInstanceFilter)this.processInstanceFilterDc.getItem();
        List activityIdIn = instanceFilter.getActiveActivityIdIn();
        String clickedElementId = elementClickEvent.getElementId();
        boolean sameElementClicked = false;
        if (CollectionUtils.isNotEmpty((Collection)activityIdIn)) {
            activityIdIn.forEach(activityId -> this.viewerFragment.removeMarker(new RemoveMarkerCmd(activityId, ElementMarkerType.PRIMARY_COLOR_ACTIVITY)));
            sameElementClicked = activityIdIn.contains(clickedElementId);
        }
        if (sameElementClicked) {
            instanceFilter.setActiveActivityIdIn(null);
            this.processInstancesFragment.clearActivity();
        } else {
            instanceFilter.setActiveActivityIdIn(List.of(clickedElementId));
            this.viewerFragment.addMarker(new AddMarkerCmd(clickedElementId, ElementMarkerType.PRIMARY_COLOR_ACTIVITY));
            this.processInstancesFragment.showActivity(clickedElementId, elementClickEvent.getElementType(), elementClickEvent.getElementName());
        }
    }

    protected void updateAllRunningInstancesCount() {
        long allVersionsInstancesCount = this.processInstanceService.getCountByProcessDefinitionKey(((ProcessDefinitionData)this.getEditedEntity()).getKey());
        this.allVersionsInstancesCountSpan.setText(String.valueOf(allVersionsInstancesCount));
    }

    protected void updateCurrentVersionInstancesCount(ProcessInstanceFilter filter) {
        long currentVersionInstancesCount = this.processInstanceService.getRuntimeInstancesCount(filter);
        this.updateTabCaption(currentVersionInstancesCount);
    }

    protected void updateTabCaption(long count) {
        this.tabsheetProcessInstancesTab.setLabel(this.messageBundle.formatMessage("processInstancesTab.label", new Object[]{count}));
        this.tabsheetProcessInstancesTab.addComponentAsFirst((Component)VaadinIcon.TASKS.create());
    }

    protected void initProcessInstanceFilter() {
        ProcessInstanceFilter processInstanceFilter = (ProcessInstanceFilter)this.metadata.create(ProcessInstanceFilter.class);
        processInstanceFilter.setUnfinished(Boolean.valueOf(true));
        this.processInstanceFilterDc.setItem((Object)processInstanceFilter);
    }

    protected void initVersionLookup(ProcessDefinitionData processDefinition) {
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setLatestVersionOnly(Boolean.valueOf(false));
        filter.setKey(processDefinition.getKey());
        List optionsList = this.processDefinitionService.findAll(new ProcessDefinitionLoadContext().setFilter(filter).setSort(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"version"})));
        this.versionComboBox.setItems((Collection)optionsList);
        this.versionComboBox.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> item.getVersion() != null ? String.valueOf(item.getVersion()) : null);
        this.versionComboBox.setValue((Object)processDefinition);
    }

    protected Span createStateBadge(boolean success, String text) {
        Span badge = (Span)this.uiComponents.create(Span.class);
        String themeNames = success ? "badge success pill" : "badge warning pill";
        badge.getElement().getThemeList().add((Object)themeNames);
        badge.setText(text);
        return badge;
    }
}

